// This version of navcompressed.js was modified to allow prevention
// of the persistence of global objectives states, node scores,
// and all node state properties except completion.  The change
// was made to facilitate reducing the amount of suspend_data being used.
// The trackAllData variable is used to turn the new "limited
// tracking" feature on and off.

//navengine.js,navmapapi.js,navmapnode.js,navnode.js,navnodeapi.js,navobjective.js,navobjectivemap.js,navpostrule.js,navrulecondagg.js,navrulecondition.js,navseqengine.js,navstaterule.js

//////////////////////
// BEGIN NavNodeAPI //
//////////////////////
function NavNodeAPI(navEngine)
{ this._winRef = window; this.navEngine = navEngine;}
NavNodeAPI.prototype.canGotoNode = NavNodeAPICanGotoNode; NavNodeAPI.prototype.gotoNode = NavNodeAPIGotoNode; NavNodeAPI.prototype.gosubNode = NavNodeAPIGosubNode; NavNodeAPI.prototype.canContinue = NavNodeAPICanNext; NavNodeAPI.prototype.canPrevious = NavNodeAPICanBack; NavNodeAPI.prototype.navContinue = NavNodeAPINavContinue; NavNodeAPI.prototype.navPrevious = NavNodeAPINavBack; NavNodeAPI.prototype.setNodeScore = NavNodeAPISetScore; NavNodeAPI.prototype.getNodeScore = NavNodeAPIGetScore; NavNodeAPI.prototype.getNodeChildIds = NavNodeAPIGetChildIds; NavNodeAPI.prototype.getNodeTitle = NavNodeAPIGetTitle; NavNodeAPI.prototype.getNodeUrl = NavNodeAPIGetUrl; NavNodeAPI.prototype.getNodeTag = NavNodeAPIGetTag; NavNodeAPI.prototype.getBooleanProperty = NavNodeAPIGetBooleanProperty; NavNodeAPI.prototype.setBooleanProperty = NavNodeAPISetBooleanProperty
NavNodeAPI.prototype.getNodeAttempted = NavNodeAPIGetAttempted; NavNodeAPI.prototype.setNodeAttempted = NavNodeAPISetAttempted; NavNodeAPI.prototype.getNodeCompleted = NavNodeAPIGetCompleted; NavNodeAPI.prototype.setNodeCompleted = NavNodeAPISetCompleted; NavNodeAPI.prototype.getNodeSatisfied = NavNodeAPIGetSatisfied; NavNodeAPI.prototype.setNodeSatisfied = NavNodeAPISetSatisfied; NavNodeAPI.prototype.getNodeSkip = NavNodeAPIGetSkip; NavNodeAPI.prototype.setNodeSkip = NavNodeAPISetSkip; NavNodeAPI.prototype.getNodeChoice = NavNodeAPIGetChoice; NavNodeAPI.prototype.setNodeChoice = NavNodeAPISetChoice; NavNodeAPI.prototype.getNodeFlow = NavNodeAPIGetFlow; NavNodeAPI.prototype.setNodeFlow = NavNodeAPISetFlow; NavNodeAPI.prototype.getNodeForwardOnly = NavNodeAPIGetForwardOnly; NavNodeAPI.prototype.setNodeForwardOnly = NavNodeAPISetForwardOnly; NavNodeAPI.prototype.getNodeBlock = NavNodeAPIGetBlock; NavNodeAPI.prototype.setNodeBlock = NavNodeAPISetBlock; NavNodeAPI.prototype.getNodeEnabled = NavNodeAPIGetEnabled; NavNodeAPI.prototype.setNodeEnabled = NavNodeAPISetEnabled; NavNodeAPI.prototype.getNodeVisible = NavNodeAPIGetVisible; NavNodeAPI.prototype.setNodeVisible = NavNodeAPISetVisible; NavNodeAPI.prototype.resetNode = NavNodeAPIResetNode; NavNodeAPI.prototype.refreshNode = NavNodeAPIRefreshNode; NavNodeAPI.prototype.getNodeId = NavNodeAPIGetNodeId; NavNodeAPI.prototype.getNodeRef = NavNodeAPIGetNodeRef; NavNodeAPI.prototype.verifyUrl = NavNodeAPIVerifyUrl; NavNodeAPI.prototype.registerEvent = NavNodeAPIRegisterEvent; NavNodeAPI.prototype.unregisterEvent = NavNodeAPIUnregisterEvent; NavNodeAPI.prototype.getChoice = NavNodeAPIGetChoice; NavNodeAPI.prototype.getFlow = NavNodeAPIGetFlow; function NavNodeAPIGetChoice()
{ return this.navEngine.getChoice();}
function NavNodeAPIGetFlow()
{ return this.navEngine.getFlow();}
function NavNodeAPIRegisterEvent(strEvent, strEvtHandler, evtContext)
{ return this.navEngine.registerEvent(strEvent, strEvtHandler, evtContext);}
function NavNodeAPIUnregisterEvent(callbackId)
{ return this.navEngine.unregisterEvent(callbackId);}
function NavNodeAPICanGotoNode(id)
{ return (this.navEngine.canGotoNode(id));}
function NavNodeAPIGotoNode(id)
{ this.navEngine.gotoNode(id);}
function NavNodeAPIGosubNode(id, retId)
{ this.navEngine.gosubNode(id, retId);}
function NavNodeAPICanNext()
{ return (this.navEngine.canNav(NAV_DIRECTION_FORWARD));}
function NavNodeAPICanBack()
{ return (this.navEngine.canNav(NAV_DIRECTION_REVERSE));}
function NavNodeAPINavContinue()
{ this.navEngine.doNav(NAV_DIRECTION_FORWARD);}
function NavNodeAPINavBack()
{ this.navEngine.doNav(NAV_DIRECTION_REVERSE);}
function NavNodeAPISetScore(id, score)
{ if (arguments.length == 1)
{ score = id; id = this.navEngine.getCurrentNode().id;}
this.navEngine.setNodeScore(id, score);}
function NavNodeAPIGetScore(id)
{ var currentNode = navEngine.getCurrentNode(); if (currentNode != null)
{ if (id == null)
{ id = currentNode.id;}
return this.navEngine.getNodeScore(id);}
else
{ return 0;}
}
function NavNodeAPIGetChildIds(id)
{ if (id == null)
{ id = this.navEngine.getCurrentNode().id;}
return this.navEngine.getNodeChildIds(id);}
function NavNodeAPIGetTitle(id)
{ var currentNode = navEngine.getCurrentNode(); if (currentNode != null)
{ if (id == null)
{ id = currentNode.id;}
return this.navEngine.getNodeTitle(id);}
else
{ return "";}
}
function NavNodeAPIGetUrl(id)
{ var currentNode = navEngine.getCurrentNode(); if (currentNode != null)
{ if (id == null)
{ id = currentNode.id;}
return this.navEngine.getNodeUrl(id);}
else
{ return "";}
}
function NavNodeAPIGetTag(id)
{ var currentNode = navEngine.getCurrentNode(); if (currentNode != null)
{ if (id == null)
{ id = currentNode.id;}
return this.navEngine.getNodeTag(id);}
else
{ return "";}
}
function NavNodeAPIGetBooleanProperty(prop, id)
{ var currentNode = navEngine.getCurrentNode(); if (currentNode != null)
{ if (id == null)
{ id = currentNode.id;}
switch (prop)
{ case PROP_ATTEMPTED:return (this.navEngine.getNodeAttempted(id)); case PROP_COMPLETED:return (this.navEngine.getNodeCompleted(id)); case PROP_SATISFIED:return (this.navEngine.getNodeSatisfied(id)); case PROP_SKIP:return (this.navEngine.getNodeSkip(id)); case PROP_BLOCK:return (this.navEngine.getNodeBlock(id)); case PROP_ENABLED:return (this.navEngine.getNodeEnabled(id)); case PROP_VISIBLE:return (this.navEngine.getNodeVisible(id)); case PROP_CHOICE:return (this.navEngine.getNodeChoice(id)); case PROP_FLOW:return (this.navEngine.getNodeFlow(id)); case PROP_FORWARD_ONLY:return (this.navEngine.getNodeForwardOnly(id)); default:return false;}
}
else
{ return false;}
}
function NavNodeAPISetBooleanProperty(prop, flag, id)
{ if (id == null)
{ id = this.navEngine.getCurrentNode().id;}
switch (prop)
{ case PROP_ATTEMPTED:this.navEngine.setNodeAttempted(id, flag);break; case PROP_COMPLETED:this.navEngine.setNodeCompleted(id, flag);break; case PROP_SATISFIED:this.navEngine.setNodeSatisfied(id, flag);break; case PROP_SKIP:this.navEngine.setNodeSkip(id, flag);break; case PROP_BLOCK:this.navEngine.setNodeBlock(id, flag);break; case PROP_ENABLED:this.navEngine.setNodeEnabled(id, flag);break; case PROP_VISIBLE:this.navEngine.setNodeVisible(id, flag);break; case PROP_CHOICE:this.navEngine.setNodeChoice(id, flag);break; case PROP_FLOW:this.navEngine.setNodeFlow(id, flag);break; case PROP_FORWARD_ONLY:this.navEngine.setNodeForwardOnly(id, flag);break;}
}
function NavNodeAPIGetAttempted(id)
{ return this.getBooleanProperty(PROP_ATTEMPTED, id);}
function NavNodeAPISetAttempted(id, flag)
{ if (arguments.length == 1)
{ flag = id; id = null;}
this.setBooleanProperty(PROP_ATTEMPTED, flag, id);}
function NavNodeAPIGetCompleted(id)
{ return this.getBooleanProperty(PROP_COMPLETED, id);}
function NavNodeAPISetCompleted(id, flag)
{ if (arguments.length == 1)
{ flag = id; id = null;}
this.setBooleanProperty(PROP_COMPLETED, flag, id);}
function NavNodeAPIGetSatisfied(id)
{ return this.getBooleanProperty(PROP_SATISFIED, id);}
function NavNodeAPISetSatisfied(id, flag)
{ if (arguments.length == 1)
{ flag = id; id = null;}
this.setBooleanProperty(PROP_SATISFIED, flag, id);}
function NavNodeAPIGetSkip(id)
{ return this.getBooleanProperty(PROP_SKIP, id);}
function NavNodeAPISetSkip(id, flag)
{ if (arguments.length == 1)
{ flag = id; id = null;}
this.setBooleanProperty(PROP_SKIP, flag, id);}
function NavNodeAPIGetChoice(id)
{ return this.getBooleanProperty(PROP_CHOICE, id);}
function NavNodeAPISetChoice(id, flag)
{ if (arguments.length == 1)
{ flag = id; id = null;}
this.setBooleanProperty(PROP_CHOICE, flag, id);}
function NavNodeAPIGetFlow(id)
{ return this.getBooleanProperty(PROP_FLOW, id);}
function NavNodeAPISetFlow(id, flag)
{ if (arguments.length == 1)
{ flag = id; id = null;}
this.setBooleanProperty(PROP_FLOW, flag, id);}
function NavNodeAPIGetForwardOnly(id)
{ return this.getBooleanProperty(PROP_FORWARD_ONLY, id);}
function NavNodeAPISetForwardOnly(id, flag)
{ if (arguments.length == 1)
{ flag = id; id = null;}
this.setBooleanProperty(PROP_FORWARD_ONLY, flag, id);}
function NavNodeAPIGetBlock(id)
{ return this.getBooleanProperty(PROP_BLOCK, id);}
function NavNodeAPISetBlock(id, flag)
{ if (arguments.length == 1)
{ flag = id; id = null;}
this.setBooleanProperty(PROP_BLOCK, flag, id);}
function NavNodeAPIGetEnabled(id)
{ return this.getBooleanProperty(PROP_ENABLED, id);}
function NavNodeAPISetEnabled(id, flag)
{ if (arguments.length == 1)
{ flag = id; id = null;}
this.setBooleanProperty(PROP_ENABLED, flag, id);}
function NavNodeAPIGetVisible(id)
{ return this.getBooleanProperty(PROP_VISIBLE, id);}
function NavNodeAPISetVisible(id, flag)
{ if (arguments.length == 1)
{ flag = id; id = null;}
this.setBooleanProperty(PROP_VISIBLE, flag, id);}
function NavNodeAPIResetNode(id)
{ if (id == null)
{ this.navEngine.resetNode(this.navEngine.getCurrentNode().id);}
else
{ this.navEngine.resetNode(id);}
}
function NavNodeAPIRefreshNode()
{ this.navEngine.showCurrent();}
function NavNodeAPIGetNodeId(nRef)
{ if (nRef == null)
{ nRef = this.navEngine.getCurrentNode();}
return this.navEngine.getNodeId(nRef);}
function NavNodeAPIGetNodeRef(id)
{ if (id == null)
{ id = this.navEngine.getCurrentNode().id;}
return this.navEngine.getNodeById(id);}
function NavNodeAPIVerifyUrl()
{ var currentNode = this.navEngine.getCurrentNode(); var currentUrl = unescape(this.navEngine.navWin.document.URL).toLowerCase().replace(/\\/g,"/"); var correctUrl = ((currentNode==null)?("*****"):(unescape(currentNode.url).toLowerCase().replace(/\\/g,"/"))); var intIndex = correctUrl.lastIndexOf("./"); if (intIndex >= 0)
{ correctUrl = correctUrl.slice(intIndex+2,correctUrl.length);}
intIndex = currentUrl.indexOf(correctUrl); if (intIndex < 0)
{ if (this.navEngine.illegalNavMessage != "")
{ }
this.navEngine.showCurrent();}
}
////////////////////
// END NavNodeAPI //
////////////////////

/////////////////////
// BEGIN NavEngine //
/////////////////////
var trackAllData = true; var DEFAULT_LOAD_STRING_SEPARATOR = "$"; var OBJ_HASH_LENGTH = 5; var NODE_HASH_LENGTH = 51; var NAV_DELAY = 1; function NavEngine()
{ this.forest = null; this.title = null; this.description = null; this.nodes = null; this.taggedNodes = null; this.numberedNodes = null; this.seqEngine = null; this.objectives = null; this.objHash = null; this.currentNode = null; this.blockedNode = null; this.navWin = null; this.illegalNavMessage = null; this.events = new EventsObject("navstatechange","navwindow","reorder","choice","flow","forwardOnly","navchange","nodecompleted","nodeattempted","nodescore","nodesatisfied","nodeblock","nodeskip","nodeenabled","nodevisible","nodechoice","nodeflow","nodeforwardonly"); this.cFlow = null; this.cChoice = null; this.cForwardOnly = null; this.loadStringSeparator = null; this.mapAPI = null; this.nodeAPI = null; this.setDefaultValues(); this.registerEvent("navstatechange","navStateChangeCallBack", this,null,true); this.htAncestorsEnabled = null; this.htNodeToRoot = null; this.arrBlockedNodes = null; this.quickReferenceContainersDirty = true;}
NavEngine.prototype.populateQuickReferenceContainers = NavEnginePopulateQuickReferenceContainers; NavEngine.prototype.navStateChangeCallBack = NavEngineNavStateChangeCallBack; NavEngine.prototype.setDefaultValues = NavEngineSetDefaultValues; NavEngine.prototype.getObjectiveById = NavEngineGetObjectiveById; NavEngine.prototype.initForest = NavEngineInitForest; NavEngine.prototype.resetForest = NavEngineResetForest; NavEngine.prototype.getTreeHash = NavEngineGetTreeHash; NavEngine.prototype.getTreeHashRec = NavEngineGetTreeHashRec; NavEngine.prototype.getBlockedNodes = NavEngineGetBlockedNodes; NavEngine.prototype.getBlockedNodesRec = NavEngineGetBlockedNodesRec; NavEngine.prototype.populateNodesTable = NavEnginePopulateNodesTable; NavEngine.prototype.populateNodesTableRec = NavEnginePopulateNodesTableRec; NavEngine.prototype.numberNodes = NavEngineNumberNodes; NavEngine.prototype.numberNodesRec = NavEngineNumberNodesRec; NavEngine.prototype.callbackReorder = NavEngineCallbackReorder; NavEngine.prototype.firstNodeInSequence = NavEngineFirstNodeInSequence; NavEngine.prototype.nextNodeInSequence = NavEngineNextNodeInSequence; NavEngine.prototype.previousNodeInSequence = NavEnginePreviousNodeInSequence; NavEngine.prototype.clearParentStacks = NavEngineClearParentStacks; NavEngine.prototype.clearParentStacksRec = NavEngineClearParentStacksRec; NavEngine.prototype.isRootNode = NavEngineIsRootNode; NavEngine.prototype.callbackNodeAttempted = NavEngineCallbackNodeAttempted; NavEngine.prototype.callbackNodeCompleted = NavEngineCallbackNodeCompleted; NavEngine.prototype.callbackNodeScore = NavEngineCallbackNodeScore; NavEngine.prototype.callbackNodeSatisfied = NavEngineCallbackNodeSatisfied; NavEngine.prototype.callbackNodeBlock = NavEngineCallbackNodeBlock; NavEngine.prototype.callbackNodeSkip = NavEngineCallbackNodeSkip; NavEngine.prototype.callbackNodeChoice = NavEngineCallbackNodeChoice; NavEngine.prototype.callbackNodeFlow = NavEngineCallbackNodeFlow; NavEngine.prototype.callbackNodeForwardOnly = NavEngineCallbackNodeForwardOnly; NavEngine.prototype.callbackNodeEnabled = NavEngineCallbackNodeEnabled; NavEngine.prototype.callbackNodeVisible = NavEngineCallbackNodeVisible; NavEngine.prototype.registerNodeEvents = NavEngineRegisterNodeEvents; NavEngine.prototype.registerNodeEventsRec = NavEngineRegisterNodeEventsRec; NavEngine.prototype.setCurrentNode = NavEngineSetCurrentNode; NavEngine.prototype.cloneForest = NavEngineCloneForest; NavEngine.prototype.cloneNode = NavEngineCloneNode; NavEngine.prototype.resolveClonedNodeReferencesRec = NavEngineResolveClonedNodeReferencesRec; NavEngine.prototype.populateNodesPropertiesRec = NavEnginePopulateNodesPropertiesRec; NavEngine.prototype.restoreNodesProperties = NavEngineRestoreNodesProperties; NavEngine.prototype.restoreNodesPropertiesRec = NavEngineRestoreNodesPropertiesRec; NavEngine.prototype.getNodeByNum = NavEngineGetNodeByNum; NavEngine.prototype.resolveNodeRef = NavEngineResolveNodeRef; NavEngine.prototype.getLastNodeInSubtree = NavEngineGetLastNodeInSubtree; NavEngine.prototype.initNav = NavEngineInitNav; NavEngine.prototype.canNav = NavEngineCanNav; NavEngine.prototype.evalNav = NavEngineEvalNav; NavEngine.prototype.getNav = NavEngineGetNav; NavEngine.prototype.doNav = NavEngineDoNav; NavEngine.prototype.toString = NavEngineToString; NavEngine.prototype.getNodeById = NavEngineGetNodeById; NavEngine.prototype.getCurrentNode = NavEngineGetCurrentNode; NavEngine.prototype.showCurrent = NavEngineShowCurrent; NavEngine.prototype.showNodeInWindow = NavEngineShowNodeInWindow; NavEngine.prototype.canGotoNode = NavEngineCanGotoNode; NavEngine.prototype.evalGotoNode = NavEngineEvalGotoNode; NavEngine.prototype.gotoNode = NavEngineGotoNode; NavEngine.prototype.gosubNode = NavEngineGosubNode; NavEngine.prototype.registerEvent = RegisterEvent; NavEngine.prototype.unregisterEvent = UnregisterEvent; NavEngine.prototype.loadFromXMLDoc = NavEngineLoadFromXMLDoc; NavEngine.prototype.getChoice = NavEngineGetChoice; NavEngine.prototype.getFlow = NavEngineGetFlow; NavEngine.prototype.getForwardOnly = NavEngineGetForwardOnly; NavEngine.prototype.resetNode = NavEngineResetNode; NavEngine.prototype.setNodeScore = NavEngineSetNodeScore; NavEngine.prototype.getNodeScore = NavEngineGetNodeScore; NavEngine.prototype.setNodeAttempted = NavEngineSetNodeAttempted; NavEngine.prototype.getNodeAttempted = NavEngineGetNodeAttempted; NavEngine.prototype.setNodeCompleted = NavEngineSetNodeCompleted; NavEngine.prototype.getNodeCompleted = NavEngineGetNodeCompleted; NavEngine.prototype.setNodeSatisfied = NavEngineSetNodeSatisfied; NavEngine.prototype.getNodeSatisfied = NavEngineGetNodeSatisfied; NavEngine.prototype.setNodeSkip = NavEngineSetNodeSkip; NavEngine.prototype.getNodeSkip = NavEngineGetNodeSkip; NavEngine.prototype.setNodeChoice = NavEngineSetNodeChoice; NavEngine.prototype.getNodeChoice = NavEngineGetNodeChoice; NavEngine.prototype.setNodeFlow = NavEngineSetNodeFlow; NavEngine.prototype.getNodeFlow = NavEngineGetNodeFlow; NavEngine.prototype.setNodeForwardOnly = NavEngineSetNodeForwardOnly; NavEngine.prototype.getNodeForwardOnly = NavEngineGetNodeForwardOnly; NavEngine.prototype.setNodeBlock = NavEngineSetNodeBlock; NavEngine.prototype.getNodeBlock = NavEngineGetNodeBlock; NavEngine.prototype.setNodeEnabled = NavEngineSetNodeEnabled; NavEngine.prototype.getNodeEnabled = NavEngineGetNodeEnabled; NavEngine.prototype.setNodeVisible = NavEngineSetNodeVisible; NavEngine.prototype.getNodeVisible = NavEngineGetNodeVisible; NavEngine.prototype.getNavWindow = NavEngineGetNavWindow; NavEngine.prototype.setNavWindow = NavEngineSetNavWindow; NavEngine.prototype.getNodeId = NavEngineGetNodeId; NavEngine.prototype.getNodeUrl = NavEngineGetNodeUrl; NavEngine.prototype.getNodeTitle = NavEngineGetNodeTitle; NavEngine.prototype.getNodeTag = NavEngineGetNodeTag; NavEngine.prototype.clone = NavEngineClone; NavEngine.prototype.getIllegalNavMessage = NavEngineGetIllegalNavMessage; NavEngine.prototype.setIllegalNavMessage = NavEngineSetIllegalNavMessage; NavEngine.prototype.clone = NavEngineClone; NavEngine.prototype.load = NavEngineLoad; NavEngine.prototype.dump = NavEngineDump; NavEngine.prototype.setLoadStringSeparator = NavEngineSetLoadStringSeparator; NavEngine.prototype.getLoadStringSeparator = NavEngineGetLoadStringSeparator; NavEngine.prototype.getLevel = NavEngineGetLevel; NavEngine.prototype.getNodeChildIds = NavEngineGetNodeChildIds; function NavEngineResolveNodeRef(id)
{ var nodeRef = null; if (typeof(id) == "string")
{ nodeRef = this.navEngine.getNodeById(id);}
else
{ if (typeof(id) == "object" && id.constructor == NavNode)
{ nodeRef = id;}
}
return nodeRef;}
function NavEngineGetLevel(id, contentOnlyFlag)
{ if (contentOnlyFlag == null)
{ contentOnlyFlag = false;}
var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ }
else
{ return -1;}
}
function NavEngineSetLoadStringSeparator(separator)
{ this.loadStringSeparator = separator;}
function NavEngineGetLoadStringSeparator()
{ return this.loadStringSeparator;}
function NavEngineLoad(strVal)
{ var separator = strVal.charAt(0); strVal = strVal.slice(1,strVal.length); var values = strVal.split(separator); var controls = new BooleanArray(values[0]); var currentNodeId = values[1]; var blockedNodeId = values[2]; var objectivesSatisfieds = new BooleanArray(values[3]); var objectivesScores = null; if (values[4] == "")
{ objectivesScores = new Array();}
else
{ objectivesScores = values[4].split(",");}
var nodePropBolArr = new BooleanArray(values[5]); var nodeScores = null; if (values[6] == "")
{ nodeScores = new Array();}
else
{ nodeScores = values[6].split(",");}
var nodeParentStacks = null; if (values[7] == "")
{ nodeParentStacks = new Array();}
else
{ nodeParentStacks = values[7].split(";");}
var nodeChildArrays = null; if (values[8] == "")
{ nodeChildArrays = new Array();}
else
{ nodeChildArrays = values[8].split(";");}
this.cFlow = controls.get(0); this.cChoice = controls.get(1); this.cForwardOnly = controls.get(2); this.currentNode = this.getNodeById(currentNodeId); this.blockedNode = this.getNodeById(blockedNodeId); for (var i=0;i<this.objectives.length;i++)
{ this.objectives[i].satisfied = objectivesSatisfieds.get(i); this.objectives[i].score = floatParse(objectivesScores[i],SCORE_PRECISION);}
this.restoreNodesProperties(nodePropBolArr, this.forest[i]); for (var i=0;i<nodeScores.length;i++)
{ var parts = nodeScores[i].split(":"); this.getNodeByNum(parts[0]).objective.score = floatParse(parts[1],SCORE_PRECISION);}
for (var i=0;i<nodeParentStacks.length;i++)
{ var parts = nodeParentStacks[i].split(":"); parts[1] = parts[1].split(","); for (var t=0;t<parts[1].length;t++)
{ this.getNodeById(parts[0]).parentStack[this.getNodeById(parts[0]).parentStack.length] = this.getNodeById(parts[1][t]);}
}
for (var i=0;i<nodeChildArrays.length;i++)
{ var parts = nodeChildArrays[i].split(":"); parts[1] = parts[1].split(","); for (var t=0;t<parts[1].length;t++)
{ this.getNodeById(parts[0]).selectedChildren[this.getNodeById(parts[0]).selectedChildren.length] = this.getNodeById(parts[1][t]);}
}
this.numberNodes(); if (this.currentNode && !this.canGotoNode(this.currentNode.id))
{ this.setCurrentNode(null);}
}
var restoreCount = 0; function NavEngineRestoreNodesProperties(boolArr)
{ restoreCount = 0; for (var i=0;i<this.forest.length;i++)
{ this.forest[i].parentStack.length = 0; this.restoreNodesPropertiesRec(boolArr, this.forest[i]);}
}
function NavEngineRestoreNodesPropertiesRec(boolArr, nodeRef)
{ if (trackAllData)
{ nodeRef.skip = boolArr.get(restoreCount++); nodeRef.cChoice = boolArr.get(restoreCount++); nodeRef.cFlow = boolArr.get(restoreCount++); nodeRef.cForwardOnly = boolArr.get(restoreCount++); nodeRef.block = boolArr.get(restoreCount++); nodeRef.enabled = boolArr.get(restoreCount++); nodeRef.visible = boolArr.get(restoreCount++);}
nodeRef.completed = boolArr.get(restoreCount++); if (trackAllData)
{ nodeRef.attempted = boolArr.get(restoreCount++); nodeRef.objective.satisfied = boolArr.get(restoreCount++);}
if (nodeRef.parentStack.length > 1)
{ nodeRef.parentStack.length = 1;}
nodeRef.selectedChildren.length = 0; for (var i=0;i<nodeRef.children.length;i++)
{ this.restoreNodesPropertiesRec(boolArr, nodeRef.children[i])
}
}
function NavEngineDump()
{ var blankArray = new Array(); var blankBoolArray = new BooleanArray(); var s = this.loadStringSeparator; var controls = new BooleanArray(); controls.set(0,this.cFlow); controls.set(1,this.cChoice); controls.set(2,this.cForwardOnly); var currentNodeId = ((this.currentNode==null)?(""):(this.currentNode.id))
var blockedNodeId = ((this.blockedNode==null)?(""):(this.blockedNode.id))
var objectivesSatisfieds = new BooleanArray(); var objectivesScores = new Array(); for (var i=0;i<this.objectives.length;i++)
{ objectivesSatisfieds.set(i,this.objectives[i].satisfied); objectivesScores[i] = (this.objectives[i].score + "");}
var nodePropBoolArr = new BooleanArray(); var nodeScores = new Array(); var nodeParentStacks = new Array(); var nodeChildArrays = new Array(); for (var i=0;i<this.forest.length;i++)
{ this.populateNodesPropertiesRec(nodePropBoolArr, nodeScores, nodeParentStacks, nodeChildArrays, this.forest[i]);}
return s + controls.dump() + s + currentNodeId + s + blockedNodeId + s + ((trackAllData)?(objectivesSatisfieds.dump()):(blankBoolArray.dump())) + s + ((trackAllData)?(objectivesScores.join(",")):(blankArray.join(","))) + s + nodePropBoolArr.dump() + s + ((trackAllData)?(nodeScores.join(",")):(blankArray.join(","))) + s + nodeParentStacks.join(";") + s + nodeChildArrays.join(";");}
function NavEnginePopulateNodesPropertiesRec(boolArr, scoreArray, parentArray, childArray, nodeRef)
{ if (trackAllData)
{ boolArr.set(boolArr.getLength(), nodeRef.skip); boolArr.set(boolArr.getLength(), nodeRef.cChoice); boolArr.set(boolArr.getLength(), nodeRef.cFlow); boolArr.set(boolArr.getLength(), nodeRef.cForwardOnly); boolArr.set(boolArr.getLength(), nodeRef.block); boolArr.set(boolArr.getLength(), nodeRef.enabled); boolArr.set(boolArr.getLength(), nodeRef.visible);}
boolArr.set(boolArr.getLength(), nodeRef.completed); if (trackAllData)
{ boolArr.set(boolArr.getLength(), nodeRef.attempted); boolArr.set(boolArr.getLength(), nodeRef.objective.satisfied);}
if (nodeRef.objective.score != 0)
{ scoreArray[scoreArray.length] = nodeRef.num + ":" + nodeRef.objective.score;}
if (nodeRef.parentStack.length > 1)
{ var tempArr = nodeRef.parentStack.slice(1,nodeRef.parentStack.length); for (var i=0;i<tempArr.length;i++)
{ tempArr[i] = tempArr[i].id;}
parentArray[parentArray.length] = nodeRef.id + ":" + tempArr.join(",");}
if (nodeRef.selectedChildren.length > 0)
{ var tempArr = nodeRef.selectedChildren.slice(0,nodeRef.selectedChildren.length); for (var i=0;i<tempArr.length;i++)
{ tempArr[i] = tempArr[i].id;}
childArray[childArray.length] = nodeRef.id + ":" + tempArr.join(",");}
for (var i=0;i<nodeRef.children.length;i++)
{ this.populateNodesPropertiesRec(boolArr, scoreArray, parentArray, childArray, nodeRef.children[i])
}
}
function NavEngineClone(bolShareForest)
{ var retVal; if (bolShareForest == null)
{ bolShareForest = true;}
if (bolShareForest == true)
{ retVal = new NavEngine(); retVal.forest = this.forest; retVal.nodes = this.nodes; retVal.taggedNodes = this.taggedNodes; retVal.numberedNodes = this.numberedNodes; retVal.seqEngine = this.seqEngine; retVal.nodeAPI = this.nodeAPI; retVal.mapAPI = this.mapAPI; retVal.objHash = this.objHash; retVal.objectives = this.objectives; retVal.currentNode = this.currentNode; retVal.blockedNode = this.blockedNode; retVal.navWin = this.navWin; retVal.illegalNavMessage = this.illegalNavMessage; retVal.events = new EventsObject("navstatechange","navwindow","reorder","choice","flow","forwardOnly","navchange","nodecompleted","nodeattempted","nodescore","nodesatisfied","nodeblock","nodeskip","nodeenabled","nodevisible"); retVal.cFlow = this.cFlow; retVal.cChoice = this.cChoice; retVal.cForwardOnly = this.cForwardOnly; retVal.title = this.title; retVal.description = this.description;}
else
{ retVal = new NavEngine(); retVal.forest = this.cloneForest(); retVal.nodes = new HashTable(NODE_HASH_LENGTH); retVal.taggedNodes = new HashTable(NODE_HASH_LENGTH); retVal.numberedNodes = new HashTable(NODE_HASH_LENGTH); retVal.seqEngine = new NavSeqEngine(retVal); retVal.mapAPI = new NavMapAPI(retVal); retVal.nodeAPI = new NavNodeAPI(retVal); retVal.objHash = new HashTable(OBJ_HASH_LENGTH); retVal.objectives = new Array(); var tempArr = this.objHash.getKeys(); for (var i=0;i<tempArr.length;i++)
{ var tempObj1 = this.objHash.retrieve(tempArr[i].toLowerCase()); var tempObj2 = new NavObjective(); tempObj2.id = tempObj1.id; tempObj2.satisfied = tempObj1.satisfied; tempObj2.score = tempObj1.score; tempObj2.events = new EventsObject("score","satisfied"); retVal.objHash.insert(tempObj2.id, tempObj2); retVal.objectives[retVal.objectives.length] = tempObj2;}
retVal.navWin = this.navWin; retVal.illegalNavMessage = this.illegalNavMessage; retVal.events = new EventsObject("navstatechange","navwindow","reorder","choice","flow","forwardOnly","navchange","nodecompleted","nodeattempted","nodescore","nodesatisfied","nodeblock","nodeskip","nodeenabled","nodevisible"); retVal.cFlow = this.cFlow; retVal.cChoice = this.cChoice; retVal.cForwardOnly = this.cForwardOnly; retVal.title = this.title; retVal.description = this.description; retVal.populateNodesTable(); for (var i=0;i<retVal.forest.length;i++)
{ this.resolveClonedNodeReferencesRec(retVal, retVal.forest[i]); retVal.forest[i].resolveReferences(retVal);}
retVal.numberNodes(); retVal.registerNodeEvents(); if (this.currentNode != null)
{ retVal.currentNode = retVal.getNodeById(this.currentNode.id);}
if (this.blockedNode != null)
{ retVal.blockedNode = retVal.getNodeById(this.blockedNode.id);}
}
return retVal;}
function NavEngineCloneForest()
{ var retVal = new Array(); for (var i=0;i<this.forest.length;i++)
{ retVal[i] = this.cloneNode(this.forest[i]);}
return retVal;}
function NavEngineCloneNode(nodeRef)
{ var retVal = new NavNode(); retVal.skip = nodeRef.skip; retVal.block = nodeRef.block; retVal.enabled = nodeRef.enabled; retVal.visible = nodeRef.visible; retVal.transparent = nodeRef.transparent; retVal.position = nodeRef.position.concat(); retVal.skipDefault = nodeRef.skipDefault; retVal.blockDefault = nodeRef.blockDefault; retVal.enabledDefault = nodeRef.enabledDefault; retVal.visibleDefault = nodeRef.visibleDefault; retVal.choiceDefault = nodeRef.choiceDefault; retVal.flowDefault = nodeRef.flowDefault; retVal.forwardOnlyDefault = nodeRef.forwardOnlyDefault; retVal.completed = nodeRef.completed; retVal.attempted = nodeRef.attempted; retVal.objective = new NavObjective(); retVal.objective.id = nodeRef.objective.id; retVal.objective.satisfied = nodeRef.objective.satisfied; retVal.objective.score = nodeRef.objective.score; retVal.objective.events = new EventsObject("satisfied", "score"); retVal.parentStack = new Array(); for (var i=0;i<nodeRef.parentStack.length;i++)
{ retVal.parentStack[i] = nodeRef.parentStack[i].id;}
retVal.selectedChildren = new Array(); for (var i=0;i<nodeRef.selectedChildren.length;i++)
{ retVal.selectedChildren[i] = nodeRef.selectedChildren[i].id;}
retVal.id = nodeRef.id; retVal.num = nodeRef.num; retVal.url = nodeRef.url; retVal.tag = nodeRef.tag; retVal.title = nodeRef.title; retVal.weight = nodeRef.weight; retVal.children = new Array(); for (var i=0;i<nodeRef.children.length;i++)
{ retVal.children[i] = this.cloneNode(nodeRef.children[i]);}
retVal.objectiveMaps = new Array(); for (i=0;i<nodeRef.objectiveMaps.length;i++)
{ retVal.objectiveMaps[i] = new NavObjectiveMap(); retVal.objectiveMaps[i].objRef = nodeRef.objectiveMaps[i].objRef.id; retVal.objectiveMaps[i].read = nodeRef.objectiveMaps[i].read; retVal.objectiveMaps[i].write = nodeRef.objectiveMaps[i].write;}
retVal.navStateRules = new Array(); for (var i=0;i<nodeRef.navStateRules.length;i++)
{ retVal.navStateRules[i] = nodeRef.navStateRules[i].clone();}
retVal.postConditionRules = new Array(); for (var i=0;i<nodeRef.postConditionRules.length;i++)
{ retVal.postConditionRules[i] = nodeRef.postConditionRules[i].clone();}
retVal.cFlow = nodeRef.cFlow; retVal.cChoice = nodeRef.cChoice; retVal.cForwardOnly = nodeRef.cForwardOnly; retVal.sRandomize = nodeRef.sRandomize; retVal.sSelect = nodeRef.sSelect; retVal.sSelectEvent = nodeRef.sSelectEvent; retVal.events = new EventsObject(DEFAULT_NODE_EVENTS); retVal.events.owner = retVal; retVal.navEngineRef = null; return retVal;}
function NavEngineResolveClonedNodeReferencesRec(navRef, nodeRef)
{ for (var i=0;i<nodeRef.parentStack.length;i++)
{ nodeRef.parentStack[i] = navRef.getNodeById(nodeRef.parentStack[i]);}
for (var i=0;i<nodeRef.selectedChildren.length;i++)
{ nodeRef.selectedChildren[i] = navRef.getNodeById(nodeRef.selectedChildren[i]);}
for (var i=0;i<nodeRef.children.length;i++)
{ this.resolveClonedNodeReferencesRec(navRef, nodeRef.children[i]);}
}
function NavEngineGetIllegalNavMessage()
{ return this.illegalNavMessage;}
function NavEngineSetIllegalNavMessage(msg)
{ this.illegalNavMessage = msg;}
function NavEngineGetNodeTag(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ return nodeRef.tag;}
}
function NavEngineGetNodeTitle(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ return nodeRef.title;}
}
function NavEngineGetNodeChildIds(id)
{ var nodeRef = this.getNodeById(id); var retVal = null; if (nodeRef != null)
{ retVal = new Array(); var childArray = nodeRef.children; if (nodeRef.selectedChildren.length > 0)
{ childArray = nodeRef.selectedChildren;}
for (var i=0;i<childArray.length;i++)
{ retVal[retVal.length] = childArray[i].id;}
}
return retVal;}
function NavEngineGetNodeUrl(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ return nodeRef.url;}
}
function NavEngineGetNodeId(nodeRef)
{ if (nodeRef != null)
{ return nodeRef.id;}
else
{ return null;}
}
function NavEngineGetNavWindow()
{ return this.navWin;}
function NavEngineSetNavWindow(winRef)
{ if (this.navWin != winRef)
{ this.navWin = winRef; this.events.raiseEvent("navwindow",this);}
return this.navWin;}
function NavEngineSetNodeVisible(id, flag)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ nodeRef.setVisible(flag);}
}
function NavEngineGetNodeVisible(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ return nodeRef.getVisible();}
}
function NavEngineSetNodeEnabled(id, flag)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ nodeRef.setEnabled(flag);}
}
function NavEngineGetNodeEnabled(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ return nodeRef.getEnabled();}
}
function NavEngineSetNodeBlock(id, flag)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ nodeRef.setBlock(flag);}
}
function NavEngineGetNodeBlock(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ return nodeRef.getBlock();}
}
function NavEngineSetNodeSkip(id, flag)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ nodeRef.setSkip(flag);}
}
function NavEngineGetNodeSkip(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ return nodeRef.getSkip();}
}
function NavEngineSetNodeChoice(id, flag)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ nodeRef.setChoice(flag);}
}
function NavEngineGetNodeChoice(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ return nodeRef.getChoice();}
}
function NavEngineSetNodeFlow(id, flag)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ nodeRef.setFlow(flag);}
}
function NavEngineGetNodeFlow(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ return nodeRef.getFlow();}
}
function NavEngineSetNodeForwardOnly(id, flag)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ nodeRef.setForwardOnly(flag);}
}
function NavEngineGetNodeForwardOnly(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ return nodeRef.getForwardOnly();}
}
function NavEngineSetNodeSatisfied(id, flag)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ nodeRef.setSatisfied(flag);}
}
function NavEngineGetNodeSatisfied(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ return nodeRef.getSatisfied();}
}
function NavEngineSetNodeCompleted(id, flag)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ nodeRef.setCompleted(flag);}
}
function NavEngineGetNodeCompleted(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ return nodeRef.getCompleted();}
}
function NavEngineSetNodeAttempted(id, flag)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ nodeRef.setAttempted(flag);}
}
function NavEngineGetNodeAttempted(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ return nodeRef.getAttempted();}
}
function NavEngineSetNodeScore(id, score)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ nodeRef.setScore(score);}
}
function NavEngineGetNodeScore(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ return nodeRef.getScore();}
}
function NavEngineResetNode(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef != null)
{ nodeRef.reset();}
}
function NavEngineGetChoice()
{ return this.cChoice;}
function NavEngineGetFlow()
{ return this.cFlow;}
function NavEngineGetForwardOnly()
{ return this.cForwardOnly;}
function NavEngineGetCurrentNode()
{ return this.currentNode;}
function NavEngineSetCurrentNode(nodeRef)
{ if (nodeRef != this.getCurrentNode())
{ if (nodeRef != null && nodeRef.parentStack.length > 0)
{ if (nodeRef.parentStack[0].cChoice != this.cChoice)
{ this.cChoice = nodeRef.parentStack[0].cChoice; this.events.raiseEvent("choice",this);}
if (nodeRef.parentStack[0].cFlow != this.cFlow)
{ this.cFlow = nodeRef.parentStack[0].cFlow; this.events.raiseEvent("flow",this);}
if (nodeRef.parentStack[0].cForwardOnly != this.cForwardOnly)
{ this.cForwardOnly = nodeRef.parentStack[0].cForwardOnly; this.events.raiseEvent("forwardOnly",this);}
}
this.currentNode = nodeRef; this.events.raiseEvent("navchange",this); this.events.raiseEvent("navstatechange",this);}
}
function NavEngineCallbackNodeAttempted(ref)
{ this.events.raiseEvent("nodeattempted",this,ref); this.events.raiseEvent("navstatechange",this,ref);}
function NavEngineCallbackNodeCompleted(ref)
{ this.events.raiseEvent("nodecompleted",this,ref); this.events.raiseEvent("navstatechange",this,ref);}
function NavEngineCallbackNodeScore(ref)
{ this.events.raiseEvent("nodescore",this,ref); this.events.raiseEvent("navstatechange",this,ref);}
function NavEngineCallbackNodeSatisfied(ref)
{ this.events.raiseEvent("nodesatisfied",this,ref); this.events.raiseEvent("navstatechange",this,ref);}
function NavEngineCallbackNodeBlock(ref)
{ this.events.raiseEvent("nodeblock",this,ref); this.events.raiseEvent("navstatechange",this,ref);}
function NavEngineCallbackNodeSkip(ref)
{ this.events.raiseEvent("nodeskip",this,ref); this.events.raiseEvent("navstatechange",this,ref);}
function NavEngineCallbackNodeChoice(ref)
{ var choiceChange = (this.currentNode != null && !this.isRootNode(this.currentNode) && this.currentNode.parentStack[0] == ref); if (choiceChange) this.cChoice = ref.cChoice; this.events.raiseEvent("nodechoice",this,ref); if (choiceChange)
{ this.events.raiseEvent("choice",this);}
this.events.raiseEvent("navstatechange",this,ref);}
function NavEngineCallbackNodeFlow(ref)
{ var flowChange = (this.currentNode != null && !this.isRootNode(this.currentNode) && this.currentNode.parentStack[0] == ref); if (flowChange) this.cFlow = ref.cFlow; this.events.raiseEvent("nodeflow",this,ref); if (flowChange)
{ this.events.raiseEvent("flow",this);}
this.events.raiseEvent("navstatechange",this,ref);}
function NavEngineCallbackNodeForwardOnly(ref)
{ var forwardOnlyChange = (this.currentNode != null && !this.isRootNode(this.currentNode) && this.currentNode.parentStack[0] == ref); if (forwardOnlyChange) this.cForwardOnly = ref.cForwardOnly; this.events.raiseEvent("nodeforwardonly",this,ref); if (forwardOnlyChange)
{ this.events.raiseEvent("forwardonly",this);}
this.events.raiseEvent("navstatechange",this,ref);}
function NavEngineCallbackNodeEnabled(ref)
{ this.events.raiseEvent("nodeenabled",this,ref); this.events.raiseEvent("navstatechange",this,ref);}
function NavEngineCallbackNodeVisible(ref)
{ this.events.raiseEvent("nodevisible",this,ref);}
function NavEngineIsRootNode(nodeRef)
{ for (var i=0;i<this.forest.length;i++)
{ if (nodeRef == this.forest[i])
{ return true;}
}
return false;}
function NavEngineClearParentStacks()
{ for (var i=0;i<this.forest.length;i++)
{ this.forest[i].parentStack.length = 0; this.clearParentStacksRec(this.forest[i]);}
}
function NavEngineClearParentStacksRec(nodeRef)
{ if (nodeRef.parentStack.length > 1)
{ nodeRef.parentStack.length = 1;}
for (var i=0;i<nodeRef.children.length;i++)
{ this.clearParentStacksRec(nodeRef.children[i]);}
}
function NavEngineCanNav(direction)
{ return (this.evalNav(direction) == NAV_DENY_NONE);}
function NavEngineCanGotoNode(id)
{ return (this.evalGotoNode(id) == NAV_DENY_NONE);}
function NavEngineFirstNodeInSequence(ptrRootNode)
{ if (ptrRootNode == null) ptrRootNode = this.forest[0]; return this.seqEngine.firstNodeInSequence(ptrRootNode);}
function NavEngineNextNodeInSequence(ptrCurrentNode, bolAdjust)
{ if (ptrCurrentNode == null) ptrCurrentNode = this.getCurrentNode(); return this.seqEngine.nextNodeInSequence(ptrCurrentNode, bolAdjust);}
function NavEnginePreviousNodeInSequence(ptrCurrentNode, bolAdjust)
{ if (ptrCurrentNode == null) ptrCurrentNode = this.getCurrentNode(); return this.seqEngine.previousNodeInSequence(ptrCurrentNode, bolAdjust);}
function NavEngineGetTreeHash(forestIndex)
{ var hashTable = new HashTable(NODE_HASH_LENGTH); if (typeof(forestIndex) == "number")
{ if (forestIndex > this.forest.length-1)
{ return null;}
forestIndex = this.forest[index];}
this.getTreeHashRec(hashTable, forestIndex); return hashTable;}
function NavEngineGetTreeHashRec(hashRef, nodeRef)
{ hashRef.insert(nodeRef.id, nodeRef); for (var i=0;i<nodeRef.children.length;i++)
{ this.getTreeHashRec(hashRef, nodeRef.children[i]);}
}
function NavEngineGetBlockedNodes(forestIndex)
{ var arr = new Array(); if (typeof(forestIndex) == "number")
{ if (forestIndex > this.forest.length-1)
{ return null;}
forestIndex = this.forest[index];}
this.getBlockedNodesRec(arr, forestIndex); return arr;}
function NavEngineGetBlockedNodesRec(arr, nodeRef)
{ if (nodeRef.block)
{ arr[arr.length] = nodeRef;}
for (var i=0;i<nodeRef.children.length;i++)
{ this.getBlockedNodesRec(arr, nodeRef.children[i]);}
}
function NavEnginePopulateQuickReferenceContainers(nodeRef, enabled, rootNodeRef, treeIndex)
{ if (!nodeRef)
{ this.htAncestorsEnabled = new HashTable(); this.htNodeToRoot = new HashTable(); this.arrBlockedNodes = new Array(); for (var i=0;i<this.forest.length;i++)
{ this.arrBlockedNodes[i] = new Array(); this.populateQuickReferenceContainers(this.forest[i], true, this.forest[i], i);}
this.quickReferenceContainersDirty = false;}
else
{ this.htAncestorsEnabled.insert(nodeRef.id, enabled); if (enabled && !nodeRef.enabled) enabled = false; this.htNodeToRoot.insert(nodeRef.id, rootNodeRef); if (nodeRef.blocked)
{ this.arrBlockedNodes[treeIndex][this.arrBlockedNodes[treeIndex].length] = nodeRef;}
for (var i=0;i<nodeRef.children.length;i++)
{ this.populateQuickReferenceContainers(nodeRef.children[i], enabled, rootNodeRef, treeIndex);}
}
}
function NavEngineNavStateChangeCallBack()
{ this.quickReferenceContainersDirty = true;}
function NavEngineEvalGotoNode(id)
{ var nodeRef = this.getNodeById(id); if (nodeRef == null)
{ return NAV_DENY_INVALID_ID;}
if (!nodeRef.getEnabled())
{ return NAV_DENY_DISABLED;}
if (this.quickReferenceContainersDirty) this.populateQuickReferenceContainers(); var ptrNext = nodeRef.parentStack[0]; if (ptrNext != null)
{ if (!ptrNext.getEnabled())
{ return NAV_DENY_PARENT_DISABLED;}
if (!this.htAncestorsEnabled.retrieve(ptrNext.id)) return NAV_DENY_ANCESTOR_DISABLED;}
var rootNodeRef = this.htNodeToRoot.retrieve(nodeRef.id); var forestIndex = null; for (var i=0;i<this.forest.length;i++)
{ if (this.forest[i].id == rootNodeRef.id)
{ forestIndex = i; break;}
}
for (var i=0;i<this.arrBlockedNodes[forestIndex].length;i++)
{ if (this.arrBlockedNodes[forestIndex][i].getNextSibling(true) != null && this.arrBlockedNodes[forestIndex][i].parentStack[0] != null)
{ var lastNodeInSubtree = this.getLastNodeInSubtree(this.arrBlockedNodes[forestIndex][i].parentStack[0]); if (nodeRef.num >= this.arrBlockedNodes[forestIndex][i].getNextSibling(true).num && nodeRef.num <= lastNodeInSubtree.num)
{ this.blockedNode = this.arrBlockedNodes[forestIndex][i]; return NAV_DENY_BLOCKED;}
}
}
if (this.firstNodeInSequence(nodeRef) == null)
{ return NAV_DENY_EXHAUSTED;}
if (this.getCurrentNode() != null)
{ if (this.getCurrentNode().parentStack.length > 0 && this.getCurrentNode().parentStack[0].cForwardOnly)
{ var parentNode = this.getCurrentNode().parentStack[0]; var nextSib = parentNode.getNextSibling(true); if ((nextSib == null && nodeRef.num > parentNode.num) || (nextSib != null && (nodeRef.num > parentNode.num && nodeRef.num < parentNode.getNextSibling(true).num)))
{ if (nodeRef.num < this.getCurrentNode().num)
{ this.blockedNode = this.getCurrentNode(); return NAV_DENY_FORWARD_ONLY;}
}
}
}
return NAV_DENY_NONE;}
function NavEngineGetLastNodeInSubtree(root)
{ var children = root.children; if (root.selectedChildren.length > 0)
{ children = root.selectedChildren;}
if (children.length == 0)
{ return root;}
else
{ return this.getLastNodeInSubtree(root.children[children.length-1]);}
}
function NavEngineGosubNode(id, retId)
{ if (retId == null)
{ if (this.getCurrentNode() != null)
{ retId = this.getCurrentNode().id;}
}
if (retId != null)
{ var retNodeRef = this.getNodeById(retId); if (this.evalGotoNode(id) == NAV_DENY_NONE && retNodeRef != null)
{ var nodeRef = this.getNodeById(id); nodeRef.parentStack[nodeRef.parentStack.length] = retNodeRef; this.setCurrentNode(this.firstNodeInSequence(nodeRef));}
else
{ this.setCurrentNode(null);}
this.showCurrent();}
else
{ this.gotoNode(id);}
}
function NavEngineGotoNode(id)
{ if (this.evalGotoNode(id) == NAV_DENY_NONE)
{ var nodeRef = this.getNodeById(id); var ptr = this.getCurrentNode(); while (ptr != null)
{ if ( (this.isRootNode(ptr) && ptr.parentStack.length > 0) || (!this.isRootNode(ptr) && ptr.parentStack.length > 1) )
{ if (ptr.num > nodeRef.num)
{ this.clearParentStacks();}
else if (ptr.getNextSibling() == null)
{ if (nodeRef.num > this.getLastNodeInSubtree(ptr).num)
{ this.clearParentStacks();}
}
else
{ if (nodeRef.num >= ptr.getNextSibling().num)
{ this.clearParentStacks();}
}
break;}
ptr = ptr.parentStack[0];}
this.setCurrentNode(this.firstNodeInSequence(nodeRef));}
else
{ this.setCurrentNode(null);}
this.showCurrent();}
var _NavUrlStack = new Array(); var _NavWinStack = new Array(); function NavEngineShowCurrent()
{ if (this.navWin != null && !this.navWin.closed)
{ if (this.getCurrentNode() == null)
{ _Splice(_NavUrlStack,0,0,"naverror.html"); _Splice(_NavWinStack,0,0,this.navWin); setTimeout("_Pop(_NavWinStack).location = _Pop(_NavUrlStack)",NAV_DELAY);}
else
{ _Splice(_NavUrlStack,0,0,this.getCurrentNode().url); _Splice(_NavWinStack,0,0,this.navWin); setTimeout("_Pop(_NavWinStack).location = _Pop(_NavUrlStack)",NAV_DELAY);}
}
}
function NavEngineShowNodeInWindow(id, winRef)
{ if (winRef != null && !winRef.closed)
{ if (this.getNodeById(id) == null)
{ winRef.document.open(); winRef.document.writeln("Navigation Fault: specified page is null"); winRef.document.close();}
else
{ _Splice(_NavUrlStack,0,0,this.getNodeById(id).url); _Splice(_NavWinStack,0,0,winRef); setTimeout("_Pop(_NavWinStack).location = _Pop(_NavUrlStack)",NAV_DELAY);}
}
}
function NavEngineInitNav()
{ var nodeRef = null; for (var i=0;i<this.forest.length;i++)
{ if (this.forest[i].getEnabled())
{ nodeRef = this.firstNodeInSequence(this.forest[i]); if (nodeRef != null)
{ break;}
}
}
this.setCurrentNode(nodeRef);}
function NavEngineDoNav(direction)
{ var objVal = null; var prevNode = this.getCurrentNode(); switch (direction)
{ case NAV_DIRECTION_FORWARD:objVal=this.seqEngine.nextInSequence(this.getCurrentNode(),true);break; case NAV_DIRECTION_REVERSE:objVal=this.seqEngine.previousInSequence(this.getCurrentNode(),true);break;}
if (objVal == null)
{ this.setCurrentNode(null);}
else
{ if (objVal.returnLocation != null)
{ var destNode = null; if (this.evalGotoNode(objVal.destination.id) == NAV_DENY_NONE)
{ destNode = this.firstNodeInSequence(objVal.destination); if (destNode != null)
{ objVal.destination.parentStack[objVal.destination.parentStack.length] = objVal.returnLocation;}
}
this.setCurrentNode(destNode);}
else
{ this.setCurrentNode(objVal.destination);}
}
this.showCurrent();}
function NavEngineGetNav(direction)
{ var objRef = null; var retVal = null; switch (direction)
{ case NAV_DIRECTION_FORWARD:objRef=this.seqEngine.nextInSequence(this.getCurrentNode());break; case NAV_DIRECTION_REVERSE:objRef=this.seqEngine.previousInSequence(this.getCurrentNode());break;}
if (objRef != null)
{ if (objRef.returnLocation != null)
{ if (this.evalGotoNode(objRef.destination.id) == NAV_DENY_NONE)
{ retVal = this.firstNodeInSequence(objRef.destination);}
}
else
{ retVal = objRef.destination;}
}
return retVal;}
function NavEngineEvalNav(direction)
{ var retVal = this.getNav(direction); if (retVal == null)
{ if (this.blockedNode == null)
{ if (direction == NAV_DIRECTION_FORWARD)
{ return NAV_DENY_BLOCKED;}
else
{ return NAV_DENY_FORWARD_ONLY;}
}
else
{ return NAV_DENY_EXHAUSTED;}
}
else
{ return NAV_DENY_NONE;}
}
function NavEngineInitForest()
{ for (var i=0;i<this.forest.length;i++)
{ this.forest[i].init();}
}
function NavEngineResetForest()
{ for (var i=0;i<this.forest.length;i++)
{ this.forest[i].reset();}
}
function NavEngineGetObjectiveById(id)
{ return this.objHash.retrieve(id.toLowerCase());}
function NavEngineGetNodeById(id)
{ var retVal = this.nodes.retrieve(id); if (retVal == null)
{ retVal = this.taggedNodes.retrieve(id);}
return retVal;}
function NavEngineGetNodeByNum(num)
{ var retVal = this.numberedNodes.retrieve(num); return retVal;}
function NavEngineToString(num)
{ var strTab = ""; var str = ""; if (num == null) num = 0; for (var i=0;i<num;i++) strTab += "\t"; str = "NavEngine:"; var strTemp = this.dump(); str += "\n" + strTab + "\tDump (length='" + strTemp.length + "'): \n" + strTab + "\t" + strTemp; str += "\n" + strTab + "\tcurrentNode: " + ((this.getCurrentNode() != null)?(this.getCurrentNode().id):("null")); str += "\n" + strTab + "\tobjectives: "; for (var i=0;i<this.objectives.length;i++)
{ str += this.objectives[i].toString(num) + ((i<this.objectives.length-1)?(","):(""));}
str += "\n" + strTab + "\tobjHash: " + this.objHash.toString(); str += "\n" + strTab + "\tnodes: " + this.nodes.toString(); str += "\n" + strTab + "\tforest: "; for (var i=0;i<this.forest.length;i++)
{ str += this.forest[i].toString(num) + ((i<this.forest.length-1)?(","):(""));}
str += "\n" + strTab + "\ttaggedNodes: " + this.taggedNodes.toString(); str += "\n" + strTab + "\tnumberedNodes: " + this.numberedNodes.toString(); return str;}
function NavEngineSetDefaultValues()
{ this.cChoice = true; this.cFlow = true; this.cForwardOnly = false; this.seqEngine = new NavSeqEngine(this); this.mapAPI = new NavMapAPI(this); this.nodeAPI = new NavNodeAPI(this); this.forest = new Array(); this.nodes = new HashTable(NODE_HASH_LENGTH); this.taggedNodes = new HashTable(NODE_HASH_LENGTH); this.numberedNodes = new HashTable(NODE_HASH_LENGTH); this.objectives = new Array(); this.objHash = new HashTable(OBJ_HASH_LENGTH); this.currentNode = null; this.blockedNode = null; this.navWin = null; this.illegalNavMessage = DEFAULT_ILLEGAL_NAV_MESSAGE; this.loadStringSeparator = DEFAULT_LOAD_STRING_SEPARATOR; this.title = ""; this.description = "";}
function NavEngineLoadFromXMLDoc(xmlDoc)
{ this.setDefaultValues(); var objectivesElement = xmlDoc.docNode.getElements("objectives"); if (objectivesElement.length >0)
{ var objectivesNode = objectivesElement[0]; var objNodes = objectivesNode.getElements("objective"); for (var i=0;i<objNodes.length;i++)
{ var objRef = new NavObjective(); objRef.loadFromXMLNode(objNodes[i]); this.objHash.insert(objRef.id, objRef); this.objectives[this.objectives.length] = objRef;}
}
var titleNode = (xmlDoc.docNode.getElements("title"))[0]; if (titleNode != null)
{ this.title = titleNode.getText();}
else
{ this.title = "";}
var descriptionNode = (xmlDoc.docNode.getElements("description"))[0]; if (descriptionNode != null)
{ this.description = descriptionNode.getText();}
else
{ this.description = "";}
var forestNode = (xmlDoc.docNode.getElements("forest"))[0]; var objNodes = forestNode.getElements("node"); for (var i=0;i<objNodes.length;i++)
{ var nodeRef = new NavNode(); nodeRef.loadFromXMLNode(objNodes[i], this); this.forest[this.forest.length] = nodeRef;}
this.populateNodesTable(); this.numberNodes(); for (var i=0;i<this.forest.length;i++)
{ this.forest[i].resolveReferences(this);}
this.initForest(); this.resetForest();}
function NavEngineRegisterNodeEvents()
{ for (var i=0;i<this.forest.length;i++)
{ this.registerNodeEventsRec(this.forest[i]);}
}
function NavEngineRegisterNodeEventsRec(nodeRef)
{ nodeRef.events.registerEvent("reorder","callbackReorder",this,null,true); nodeRef.events.registerEvent("attempted","callbackNodeAttempted",this,null,true); nodeRef.events.registerEvent("completed","callbackNodeCompleted",this,null,true); nodeRef.events.registerEvent("satisfied","callbackNodeSatisfied",this,null,true); nodeRef.events.registerEvent("score","callbackNodeScore",this,null,true); nodeRef.events.registerEvent("block","callbackNodeBlock",this,null,true); nodeRef.events.registerEvent("skip","callbackNodeSkip",this,null,true); nodeRef.events.registerEvent("enabled","callbackNodeEnabled",this,null,true); nodeRef.events.registerEvent("visible","callbackNodeVisible",this,null,true); nodeRef.events.registerEvent("choice","callbackNodeChoice",this,null,true); nodeRef.events.registerEvent("flow","callbackNodeFlow",this,null,true); nodeRef.events.registerEvent("forwardOnly","callbackNodeForwardOnly",this,null,true); for (var i=0;i<nodeRef.children.length;i++)
{ this.registerNodeEventsRec(nodeRef.children[i]);}
}
function NavEngineCallbackReorder(ref)
{ this.numberNodes(); this.events.raiseEvent("reorder",this,ref); this.events.raiseEvent("navstatechange",this,ref);}
var NODE_COUNT = 0; function NavEngineNumberNodes()
{ NODE_COUNT = 0; this.numberedNodes = new HashTable(NODE_HASH_LENGTH); for (var i=0;i<this.forest.length;i++)
{ this.numberNodesRec(this.forest[i], [], i+1);}
}
function NavEngineNumberNodesRec(nodeRef, positionArray, positionNum)
{ var nextNum = 1; var posArray = positionArray.concat(); nodeRef.num = NODE_COUNT++; this.numberedNodes.insert(nodeRef.num, nodeRef); for (var i=0;i<nodeRef.children.length;i++)
{ nodeRef.children[i].num = null;}
var childArray = nodeRef.children; if (nodeRef.selectedChildren.length > 0)
{ childArray = nodeRef.selectedChildren;}
if (nodeRef.transparent && nodeRef.parentStack[0] != null)
{ for (var i=0;i<childArray.length;i++)
{ positionNum = this.numberNodesRec(childArray[i], posArray, positionNum);}
}
else
{ posArray[posArray.length] = positionNum++; for (var i=0;i<childArray.length;i++)
{ nextNum = this.numberNodesRec(childArray[i], posArray, nextNum);}
}
if (nodeRef.transparent && nodeRef.parentStack[0] != null)
{ var num = positionNum; for (var i=0;i<nodeRef.children.length;i++)
{ if (nodeRef.children[i].num == null)
{ num = this.numberNodesRec(nodeRef.children[i], posArray, num);}
}
}
else
{ var num = nextNum; for (var i=0;i<nodeRef.children.length;i++)
{ if (nodeRef.children[i].num == null)
{ num = this.numberNodesRec(nodeRef.children[i], posArray, num);}
}
}
nodeRef.position = posArray; return positionNum;}
function NavEnginePopulateNodesTable()
{ for (var i=0;i<this.forest.length;i++)
{ this.populateNodesTableRec(this.forest[i]);}
}
function NavEnginePopulateNodesTableRec(nodeRef)
{ this.nodes.insert(nodeRef.id,nodeRef); if (nodeRef.tag != "")
{ this.taggedNodes.insert(nodeRef.tag,nodeRef);}
for (var i=0;i<nodeRef.children.length;i++)
{ this.populateNodesTableRec(nodeRef.children[i]);}
}
///////////////////
// END NavEngine //
///////////////////

//////////////////////
// BEGIN NavMapNode //
//////////////////////
function NavMapNode(nodeRef, navRef)
{ this.nodeRef = nodeRef; this.navRef = navRef; this.id = ""; this.tag = ""; this.title = ""; this.blockingNodeId = ""; this.blocked = false; this.blockedForwardOnly = false; this.disabled = false; this.exhausted = false; this.visible = true; this.containsCurrentNode = false; this.isCurrentNode = false; this.position = new Array(); this.order = 0; this.depth = 0; this.attempted = false; this.completed = false; this.satisfied = false; this.parent = null; this.children = new Array(); if (nodeRef != null && typeof(nodeRef) == "object" && nodeRef.constructor == NavNode)
{ this.id = nodeRef.id; this.tag = nodeRef.tag; this.title = nodeRef.title; this.visible = nodeRef.visible; this.attempted = nodeRef.attempted; this.completed = nodeRef.completed; this.satisfied = nodeRef.satisfied; this.position = nodeRef.position.concat(); this.order = this.position[this.position.length-1]; this.depth = this.position.length-1; var retVal = navRef.evalGotoNode(nodeRef.id); if (retVal != NAV_DENY_NONE)
{ switch (retVal)
{ case NAV_DENY_BLOCKED:this.blocked=true;this.blockingNodeId=navRef.blockedNode.id;break; case NAV_DENY_ANCESTOR_DISABLED:this.disabled=true;break; case NAV_DENY_PARENT_DISABLED:this.disabled=true;break; case NAV_DENY_DISABLED:this.disabled=true;break; case NAV_DENY_FORWARD_ONLY:this.blockedForwardOnly=true;this.blockingNodeId=navRef.blockedNode.id;break; case NAV_DENY_EXHAUSTED:this.exhausted=true;break;}
}
var currentNode = navEngine.currentNode; if (currentNode != null)
{ if (currentNode == nodeRef)
{ this.containsCurrentNode = true; this.isCurrentNode = true;}
else
{ var tempNode = currentNode.parentStack[0]; while (tempNode != null)
{ if (nodeRef == tempNode)
{ this.containsCurrentNode = true; break;}
tempNode = tempNode.parentStack[0];}
}
}
}
}
////////////////////
// END NavMapNode //
////////////////////

/////////////////////
// BEGIN NavMapAPI //
/////////////////////
function NavMapAPI(navEngine)
{ this._winRef = window; this.navEngine = navEngine;}
NavMapAPI.prototype.createMapNode = NavMapAPICreateMapNode; NavMapAPI.prototype.getChildren = NavMapAPIGetChildren; NavMapAPI.prototype.getChildrenRec = NavMapAPIGetChildrenRec; NavMapAPI.prototype.getLessonDescription = NavMapAPIGetLessonDescription; NavMapAPI.prototype.getLessonTitle = NavMapAPIGetLessonTitle; NavMapAPI.prototype.getMainRootId = NavMapAPIGetMainRootId; NavMapAPI.prototype.getParentId = NavMapAPIGetParentId; NavMapAPI.prototype.getRootId = NavMapAPIGetRootId; NavMapAPI.prototype.getRootToNode = NavMapAPIGetRootToNode; NavMapAPI.prototype.getRootToNodeRec = NavMapAPIGetRootToNodeRec; NavMapAPI.prototype.getSiblings = NavMapAPIGetSiblings; NavMapAPI.prototype.getSubtree = NavMapAPIGetSubtree; NavMapAPI.prototype.getSubtreeRec = NavMapAPIGetSubtreeRec; NavMapAPI.prototype.resolveNodeRef = NavMapAPIResolveNodeRef; function NavMapAPIGetLessonTitle()
{ return this.navEngine.title;}
function NavMapAPIGetLessonDescription()
{ return this.navEngine.description;}
function NavMapAPIGetRootToNode(id)
{ var nodeRef = this.resolveNodeRef(id); if (nodeRef != null)
{ var retVal = this.getRootToNodeRec(nodeRef); var child = retVal; while (retVal.parent != null)
{ retVal.parent.children[retVal.parent.children.length] = child; child = retVal.parent; retVal = retVal.parent;}
return retVal;}
else
{ return null;}
}
function NavMapAPIGetRootToNodeRec(nodeRef)
{ if (!nodeRef.transparent || this.navEngine.isRootNode(nodeRef))
{ var mapNodeRef = new NavMapNode(nodeRef, this.navEngine); if (!this.navEngine.isRootNode(nodeRef))
{ mapNodeRef.parent = this.getRootToNodeRec(nodeRef.parentStack[0]);}
return mapNodeRef;}
else if (nodeRef.transparent && !this.navEngine.isRootNode(nodeRef))
{ return this.getRootToNodeRec(nodeRef.parentStack[0]);}
}
function NavMapAPIGetSubtree(id)
{ var nodeRef = this.resolveNodeRef(id); if (nodeRef != null)
{ var root = new NavMapNode(nodeRef, this.navEngine); this.getSubtreeRec(root, nodeRef); return root;}
else
{ return null;}
}
function NavMapAPIGetSubtreeRec(mapNode, navNode)
{ var childArray = navNode.children; if (navNode.selectedChildren.length > 0)
{ childArray = navNode.selectedChildren;}
for (var i=0;i<childArray.length;i++)
{ if (childArray[i].visible)
{ mapNode.children[mapNode.children.length] = new NavMapNode(childArray[i], this.navEngine); this.getSubtreeRec(mapNode.children[mapNode.children.length-1], childArray[i]);}
}
}
function NavMapAPIGetSiblings(id, contentOnly)
{ var nodeRef = this.resolveNodeRef(id); if (nodeRef != null)
{ var parentId = this.getParentId(nodeRef); while (parentId != null && this.navEngine.getNodeById(parentId).transparent)
{ parentId = this.getParentId(parentId);}
if (parentId != null)
{ return this.getChildren(parentId, contentOnly);}
}
return null;}
function NavMapAPIGetChildren(id, contentOnly)
{ var nodeRef = this.resolveNodeRef(id); if (nodeRef != null)
{ var retVal = new NavMapNode(nodeRef, this.navEngine); var childArray = nodeRef.children; if (nodeRef.selectedChildren.length > 0)
{ childArray = nodeRef.selectedChildren;}
for (var i=0;i<childArray.length;i++)
{ this.getChildrenRec(childArray[i], retVal, contentOnly);}
return retVal;}
else
{ return null;}
}
function NavMapAPIGetChildrenRec(childNodeRef, mapNodeParentRef, contentOnly)
{ if (childNodeRef.visible)
{ if (childNodeRef.transparent || (contentOnly && childNodeRef.getUrl() == ""))
{ var childArray = childNodeRef.children; if (childNodeRef.selectedChildren.length > 0)
{ childArray = childNodeRef.selectedChildren;}
for (var i=0;i<childArray.length;i++)
{ this.getChildrenRec(childArray[i], mapNodeParentRef, contentOnly);}
}
else
{ var navMapNode = new NavMapNode(childNodeRef, this.navEngine); navMapNode.parent = mapNodeParentRef; mapNodeParentRef.children[mapNodeParentRef.children.length] = navMapNode;}
}
}
function NavMapAPIGetParentId(id)
{ var nodeRef = this.resolveNodeRef(id); if (nodeRef != null)
{ var nextNode = nodeRef; while (nextNode != null)
{ if (nextNode.parentStack.length > 0 && !this.navEngine.isRootNode(nextNode))
{ nextNode = nextNode.parentStack[0]; if (!nextNode.transparent)
{ return nextNode.id;}
}
else
{ if (nextNode != nodeRef)
{ return nextNode.id;}
else
{ return null;}
}
}
}
else
{ return null;}
}
function NavMapAPIGetRootId(id)
{ var nodeRef = this.resolveNodeRef(id); if (nodeRef != null)
{ while (!this.navEngine.isRootNode(nodeRef))
{ nodeRef = nodeRef.parentStack[0];}
return nodeRef;}
else
{ return null;}
}
function NavMapAPIGetMainRootId()
{ return this.navEngine.forest[0].id;}
function NavMapAPIResolveNodeRef(id)
{ var nodeRef = null; if (typeof(id) == "string")
{ nodeRef = this.navEngine.getNodeById(id);}
else
{ if (typeof(id) == "object" && id.constructor == NavNode)
{ nodeRef = id;}
else
{ if (id == null)
{ nodeRef = this.navEngine.getCurrentNode();}
}
}
return nodeRef;}
function NavMapAPICreateMapNode(id)
{ var nodeRef = this.resolveNodeRef(id); if (nodeRef != null)
{ return new NavMapNode(nodeRef, this.navEngine);}
else
{ return null;}
}
///////////////////
// END NavMapAPI //
///////////////////

///////////////////
// BEGIN NavNode //
///////////////////
function NavNode()
{ this.skip = null; this.block = null; this.enabled = null; this.visible = null; this.completed = null; this.attempted = null; this.objective = null; this.parentStack = null; this.selectedChildren = null; this.position = null; this.cFlow = null; this.cChoice = null; this.cForwardOnly = null; this.skipDefault = null; this.blockDefault = null; this.enabledDefault = null; this.visibleDefault = null; this.choiceDefault = null; this.flowDefault = null; this.forwardOnlyDefault = null; this.id = null; this.num = null; this.url = null; this.tag = null; this.title = null; this.weight = null; this.children = null; this.objectiveMaps = null; this.navStateRules = null; this.postConditionRules = null; this.transparent = null; this.sRandomize = null; this.sSelect = null; this.sSelectEvent = null; this.events = null; this.navEngineRef = null;}
NavNode.prototype.loadFromXMLNode = NavNodeLoadFromXMLNode; NavNode.prototype.setDefaultValues = NavNodeSetDefaultValues; NavNode.prototype.toString = NavNodeToString; NavNode.prototype.init = NavNodeInit; NavNode.prototype.reset = NavNodeReset; NavNode.prototype.resolveReferences = NavNodeResolveReferences; NavNode.prototype.getSatisfied = NavNodeGetSatisfied; NavNode.prototype.setSatisfied = NavNodeSetSatisfied; NavNode.prototype.getScore = NavNodeGetScore; NavNode.prototype.setScore = NavNodeSetScore; NavNode.prototype.getAttempted = NavNodeGetAttempted; NavNode.prototype.setAttempted = NavNodeSetAttempted; NavNode.prototype.getCompleted = NavNodeGetCompleted; NavNode.prototype.setCompleted = NavNodeSetCompleted; NavNode.prototype.getSkip = NavNodeGetSkip; NavNode.prototype.setSkip = NavNodeSetSkip; NavNode.prototype.getChoice = NavNodeGetChoice; NavNode.prototype.setChoice = NavNodeSetChoice; NavNode.prototype.getFlow = NavNodeGetFlow; NavNode.prototype.setFlow = NavNodeSetFlow; NavNode.prototype.getForwardOnly = NavNodeGetForwardOnly; NavNode.prototype.setForwardOnly = NavNodeSetForwardOnly; NavNode.prototype.getBlock = NavNodeGetBlock; NavNode.prototype.setBlock = NavNodeSetBlock; NavNode.prototype.getEnabled = NavNodeGetEnabled; NavNode.prototype.setEnabled = NavNodeSetEnabled; NavNode.prototype.getVisible = NavNodeGetVisible; NavNode.prototype.setVisible = NavNodeSetVisible; NavNode.prototype.registerEvent = RegisterEvent; NavNode.prototype.calculateScore = NavNodeCalculateScore; NavNode.prototype.getPostAction = NavNodeGetPostAction; NavNode.prototype.callbackChildAttempted = NavNodeCallbackChildAttempted; NavNode.prototype.callbackScore = function (ref){this.events.raiseEvent("score", this);}; NavNode.prototype.callbackSatisfied = function (ref){this.events.raiseEvent("satisfied", this);}; NavNode.prototype.getNextSibling = NavNodeGetNextSibling; NavNode.prototype.getPreviousSibling = NavNodeGetPreviousSibling; NavNode.prototype.eventMonitor = NavNodeEventMonitor; NavNode.prototype.getId = NavNodeGetId; NavNode.prototype.getTitle = NavNodeGetTitle; NavNode.prototype.getTag = NavNodeGetTag; NavNode.prototype.getUrl = NavNodeGetUrl; NavNode.prototype.containsNode = NavNodeContainsNode; function NavNodeContainsNode(id)
{ if (this.id == id)
{ return true;}
else
{ for (var i=0;i<this.children.length;i++)
{ if (this.children[i].containsNode(id))
{ return true;}
}
}
return false;}
function NavNodeGetId()
{ return this.id;}
function NavNodeGetTitle()
{ return this.title;}
function NavNodeGetTag()
{ return this.tag;}
function NavNodeGetUrl()
{ return this.url;}
function NavNodeGetPreviousSibling(bolUseSelected)
{ if (this.parentStack[0] == null) return null; var childArray = this.parentStack[0].children; if (bolUseSelected && this.parentStack[0].selectedChildren.length > 0)
{ childArray = this.parentStack[0].selectedChildren;}
for (var i=1;i<childArray.length;i++)
{ if (childArray[i] == this)
{ return childArray[i-1];}
}
return null;}
function NavNodeGetNextSibling(bolUseSelected)
{ if (this.parentStack[0] == null) return null; var childArray = this.parentStack[0].children; if (bolUseSelected && this.parentStack[0].selectedChildren.length > 0)
{ childArray = this.parentStack[0].selectedChildren;}
for (var i=0;i<childArray.length-1;i++)
{ if (childArray[i] == this)
{ return childArray[i+1];}
}
return null;}
function NavNodeCallbackChildAttempted(ref)
{ var flag = ref.getAttempted(); if (flag == true)
{ this.setAttempted(true);}
else if (this.getAttempted())
{ var childArray = this.children; for (var i=0;i<childArray.length;i++)
{ if (childArray[i].getAttempted())
{ return;}
}
this.setAttempted(false);}
}
function NavNodeGetPostAction(direction)
{ var retVal = new Object(); retVal.value = 0; retVal.parameters = new Array(); for (var i=0;i<this.postConditionRules.length;i++)
{ if ((this.postConditionRules[i].direction & direction) > 0 && this.postConditionRules[i].action == NAV_POST_ACTION_RESET)
{ if (this.postConditionRules[i].evaluate() == true)
{ retVal.value = retVal.value | NAV_POST_ACTION_RESET; break;}
}
}
for (var i=0;i<this.postConditionRules.length;i++)
{ if ((this.postConditionRules[i].direction & direction) > 0 && this.postConditionRules[i].action != NAV_POST_ACTION_RESET)
{ if (this.postConditionRules[i].evaluate() == true)
{ retVal.value = retVal.value | this.postConditionRules[i].action; retVal.parameters = this.postConditionRules[i].params.slice(0,this.postConditionRules[i].params.length); break;}
}
}
return retVal;}
function NavNodeCalculateScore(ref)
{ var scores = 0; var weights = 0; var childArray = null; if (this.selectedChildren.length > 0)
{ childArray = this.selectedChildren;}
else
{ childArray = this.children;}
for (var i=0;i<childArray.length;i++)
{ scores += childArray[i].weight * childArray[i].getScore(); weights += childArray[i].weight;}
this.setScore(scores/weights);}
function NavNodeGetSkip()
{ return this.skip;}
function NavNodeSetSkip(flag)
{ if (this.skip != flag)
{ this.skip = flag; this.events.raiseEvent("skip",this);}
}
function NavNodeGetChoice()
{ return this.cChoice;}
function NavNodeSetFlow(flag)
{ if (this.cFlow != flag)
{ this.cFlow = flag; this.events.raiseEvent("flow",this);}
}
function NavNodeGetFlow()
{ return this.cFlow;}
function NavNodeSetForwardOnly(flag)
{ if (this.cForwardOnly != flag)
{ this.cForwardOnly = flag; this.events.raiseEvent("forwardOnly",this);}
}
function NavNodeGetForwardOnly()
{ return this.cForwardOnly;}
function NavNodeSetChoice(flag)
{ if (this.cChoice != flag)
{ this.cChoice = flag; this.events.raiseEvent("choice",this);}
}
function NavNodeGetBlock()
{ return this.block;}
function NavNodeSetBlock(flag)
{ if (this.block != flag)
{ this.block = flag; this.events.raiseEvent("block",this);}
}
function NavNodeGetEnabled()
{ return this.enabled;}
function NavNodeSetEnabled(flag)
{ if (this.enabled != flag)
{ this.enabled = flag; this.events.raiseEvent("enabled",this);}
}
function NavNodeGetVisible()
{ return this.visible;}
function NavNodeSetVisible(flag)
{ if (this.visible != flag)
{ this.visible = flag; this.events.raiseEvent("visible",this);}
}
function NavNodeGetAttempted()
{ return this.attempted;}
function NavNodeSetAttempted(flag)
{ if (this.attempted != flag)
{ this.attempted = flag; this.events.raiseEvent("attempted",this);}
}
function NavNodeGetCompleted()
{ return this.completed;}
function NavNodeSetCompleted(flag)
{ if (this.completed != flag)
{ this.completed = flag; this.events.raiseEvent("completed",this);}
}
function NavNodeGetScore()
{ for (var i=0;i<this.objectiveMaps.length;i++)
{ if (this.objectiveMaps[i].read == true)
{ return this.objectiveMaps[i].objRef.getScore();}
}
return this.objective.getScore();}
function NavNodeSetScore(score)
{ score = floatParse(score,SCORE_PRECISION); if (this.getScore() != score)
{ for (var i=0;i<this.objectiveMaps.length;i++)
{ if (this.objectiveMaps[i].write == true)
{ this.objectiveMaps[i].objRef.setScore(score);}
}
this.objective.setScore(score);}
}
function NavNodeGetSatisfied()
{ for (var i=0;i<this.objectiveMaps.length;i++)
{ if (this.objectiveMaps[i].read == true)
{ return this.objectiveMaps[i].objRef.getSatisfied();}
}
return this.objective.getSatisfied();}
function NavNodeSetSatisfied(flag)
{ for (var i=0;i<this.objectiveMaps.length;i++)
{ if (this.objectiveMaps[i].write == true)
{ this.objectiveMaps[i].objRef.setSatisfied(flag);}
}
this.objective.setSatisfied(flag);}
function NavNodeResolveReferences(navRef)
{ var eventRegistered = false; for (var i=0;i<this.objectiveMaps.length;i++)
{ this.objectiveMaps[i].objRef = navRef.getObjectiveById(this.objectiveMaps[i].objRef); if (this.objectiveMaps[i].read && !eventRegistered)
{ this.objectiveMaps[i].objRef.registerEvent("score", "callbackScore", this,null,true); this.objectiveMaps[i].objRef.registerEvent("satisfied", "callbackSatisfied", this,null,true); eventRegistered = true;}
}
if (!eventRegistered)
{ this.objective.registerEvent("score", "callbackScore", this,null,true); this.objective.registerEvent("satisfied", "callbackSatisfied", this,null,true);}
for (var i=0;i<this.navStateRules.length;i++)
{ this.navStateRules[i].target = this; this.navStateRules[i].resolveReferences(navRef);}
for (var i=0;i<this.postConditionRules.length;i++)
{ this.postConditionRules[i].resolveReferences(navRef);}
for (var i=0;i<this.children.length;i++)
{ this.children[i].resolveReferences(navRef); this.children[i].registerEvent("attempted","callbackChildAttempted",this,null,true);}
}
function NavNodeInit()
{ if (this.sSelect > 0 && this.sSelectEvent == NAV_EVENT_INIT)
{ var bag = new Bag(); this.selectedChildren = new Array(); for (var i=0;i<this.children.length;i++)
{ bag.insert(this.children[i]);}
for (var i=0;i<this.sSelect;i++)
{ this.selectedChildren[this.selectedChildren.length] = bag.remove();}
this.events.raiseEvent("reorder",this);}
for (var i=0;i<this.children.length;i++)
{ this.children[i].init();}
}
function NavNodeReset()
{ if (this.sSelect > 0 && this.sSelectEvent == NAV_EVENT_RESET)
{ var bag = new Bag(); this.selectedChildren = new Array(); for (var i=0;i<this.children.length;i++)
{ bag.insert(this.children[i]);}
for (var i=0;i<this.sSelect;i++)
{ this.selectedChildren[this.selectedChildren.length] = bag.remove();}
this.events.raiseEvent("reorder",this);}
else if (this.sRandomize)
{ if (this.selectedChildren.length > 0)
{ var bag = new Bag(); for (var i=0;i<this.selectedChildren.length;i++)
{ bag.insert(this.selectedChildren[i]);}
this.selectedChildren = new Array(); while (bag.getLength() > 0)
{ this.selectedChildren[this.selectedChildren.length] = bag.remove();}
}
else
{ var bag = new Bag(); for (var i=0;i<this.children.length;i++)
{ bag.insert(this.children[i]);}
while (bag.getLength() > 0)
{ this.selectedChildren[this.selectedChildren.length] = bag.remove();}
}
this.events.raiseEvent("reorder",this);}
this.setSkip(this.skipDefault); this.setChoice(this.choiceDefault); this.setFlow(this.flowDefault); this.setForwardOnly(this.forwardOnlyDefault); this.setBlock(this.blockDefault); this.setEnabled(this.enabledDefault); this.setVisible(this.visibleDefault); this.setCompleted(false); this.setAttempted(false); this.setSatisfied(false); this.setScore(0); for (var i=0;i<this.children.length;i++)
{ this.children[i].reset();}
}
function NavNodeToString(num)
{ var strTab = ""; var str = ""; var strChildren = ""; var strSelectedChildren = ""; var strParentStack = ""; var strObjMaps = ""; var strNavStateRules = ""; var strPostRules = ""; for (var i=0;i<this.postConditionRules.length;i++)
{ strPostRules += this.postConditionRules[i].toString() + " | ";}
if (strPostRules.length > 3) strPostRules = strPostRules.slice(0,strPostRules.length-3); for (var i=0;i<this.navStateRules.length;i++)
{ strNavStateRules += this.navStateRules[i].toString() + " | ";}
if (strNavStateRules.length > 3) strNavStateRules = strNavStateRules.slice(0,strNavStateRules.length-3); for (var i=0;i<this.objectiveMaps.length;i++)
{ strObjMaps += "(objRef='" + this.objectiveMaps[i].objRef.id + "', " + ((this.objectiveMaps[i].read)?("read"):("no read")) + ", " + ((this.objectiveMaps[i].write)?("write"):("no write")) + ") | ";}
if (strObjMaps.length > 3) strObjMaps = strObjMaps.slice(0,strObjMaps.length-3); for (var i=0;i<this.parentStack.length;i++)
{ strParentStack += this.parentStack[i].id + " | ";}
if (strParentStack.length > 3) strParentStack = strParentStack.slice(0,strParentStack.length-3); for (var i=0;i<this.children.length;i++)
{ strChildren += this.children[i].id + " | ";}
if (strChildren.length > 3) strChildren = strChildren.slice(0,strChildren.length-3); for (var i=0;i<this.selectedChildren.length;i++)
{ strSelectedChildren += this.selectedChildren[i].id + " | ";}
if (strSelectedChildren.length > 3) strSelectedChildren = strSelectedChildren.slice(0,strSelectedChildren.length-3); if (num == null) num = 0; for (var i=0;i<num;i++) strTab += "\t"; str = strTab + "[NavNode: " + "id=\"" + this.id + "\", " + "num=\"" + this.num + "\", " + "title=\"" + this.title + "\", " + "tag=\"" + this.tag + "\", " + "url=\"" + this.url + "\", " + "objective=\"(satisfied='" + this.objective.satisfied + "' score='" + this.objective.score +"')\", " + "objectiveMaps=\"" + strObjMaps + "\", " + "navStateRules=\"" + strNavStateRules + "\", " + "postConditionRules=\"" + strPostRules + "\", " + "weight=\"" + this.weight + "\", " + "flags=\"" + ((this.skip)?("skip | "):("don't skip | ")) + ((this.block)?("blocked | "):("not blocked | ")) + ((this.enabled)?("enabled | "):("disabled | ")) + ((this.visible)?("visible | "):("hidden | ")) + ((this.attempted)?("attempted | "):("not attempted | ")) + ((this.completed)?("completed"):("not completed")) + "\"" + ", " + "controlModes=\"" + ((this.cFlow)?("flow | "):("no flow | ")) + ((this.cChoice)?("choice | "):("no choice | ")) + ((this.cForwardOnly)?("forward only"):("forward/backward")) + "\"" + ", selectionControls=\"" + ((this.sRandomize)?("randomize on reset"):("no randomization")) + " | " + ((this.sSelect>0)?("select " + this.sSelect + " of " + this.children.length + " on " + ((this.sSelectEvent==NAV_EVENT_INIT)?("init"):("")) + ((this.sSelectEvent==NAV_EVENT_RESET)?("reset"):(""))):("select all " + this.children.length)) + "\"" + ", parentStack=\"" + strParentStack + "\"" + ", children=\"" + strChildren + "\"" + ", selectedChildren=\"" + strSelectedChildren + "\"" + "]"; return str;}
function NavNodeSetDefaultValues()
{ this.skip = false; this.block = false; this.enabled = true; this.visible = true; this.skipDefault = false; this.choiceDefault = true; this.flowDefault = true; this.forwardOnlyDefault = false; this.blockDefault = false; this.enabledDefault = true; this.visibleDefault = true; this.completed = false; this.attempted = false; this.transparent = false; this.id = ""; this.num = -1; this.url = ""; this.tag = ""; this.title = ""; this.objective = new NavObjective(); this.weight = 1; this.position = new Array(); this.parentStack = new Array(); this.children = new Array(); this.selectedChildren = new Array(); this.objectiveMaps = new Array(); this.navStateRules = new Array(); this.postConditionRules = new Array(); this.cFlow = true; this.cChoice = true; this.cForwardOnly = false; this.sRandomize = false; this.sSelect = 0; this.sSelectEvent = NAV_EVENT_INIT; this.events = new EventsObject(DEFAULT_NODE_EVENTS); this.events.owner = this; this.navEngineRef = null;}
function NavNodeLoadFromXMLNode(xmlNode, navEngineRef)
{ this.setDefaultValues(); this.navEngineRef = navEngineRef; this.id = xmlNode.getAttribute("id"); var url = xmlNode.getAttribute("url"); if (url != null)
{ this.url = url;}
if ((xmlNode.getAttribute("transparent")+"") == "true")
{ this.transparent = true;}
if ((xmlNode.getAttribute("skip")+"") == "true")
{ this.skip = true; this.skipDefault = true;}
if ((xmlNode.getAttribute("block")+"") == "true")
{ this.block = true; this.blockDefault = true;}
if ((xmlNode.getAttribute("enabled")+"") == "false")
{ this.enabled = false; this.enabledDefault = false;}
if ((xmlNode.getAttribute("visible")+"") == "false")
{ this.visible = false; this.visibleDefault = false;}
var tag = xmlNode.getAttribute("tag"); if (tag != null)
{ this.tag = tag;}
var title = xmlNode.getAttribute("title"); if (title != null)
{ this.title = title;}
var weight = xmlNode.getAttribute("weight"); if (weight != null)
{ this.weight = parseFloat(weight);}
if ((xmlNode.getAttribute("flow")+"") == "false")
{ this.cFlow = false; this.flowDefault = false;}
if ((xmlNode.getAttribute("choice")+"") == "false")
{ this.cChoice = false; this.choiceDefault = false;}
if ((xmlNode.getAttribute("forwardOnly")+"") == "true")
{ this.cForwardOnly = true; this.forwardOnlyDefault = true;}
var arrMap = new Array(); var arrNavStateRules = new Array(); var arrPostStateRules = new Array(); var arrSelectionControls = new Array(); var arrChildren = new Array(); if (xmlNode.children)
{ for (var i=0; i<xmlNode.children.length; i++)
{ if (xmlNode.children[i].nodeType=='ELEMENT')
{ switch (xmlNode.children[i].tagName)
{ case "objMap":arrMap[arrMap.length] = xmlNode.children[i];break; case "navStateRules":arrNavStateRules[arrNavStateRules.length] = xmlNode.children[i];break; case "postConditionRules":arrPostStateRules[arrPostStateRules.length] = xmlNode.children[i];break; case "selectionControls":arrSelectionControls[arrSelectionControls.length] = xmlNode.children[i];break; case "children":arrChildren[arrChildren.length] = xmlNode.children[i];break;}
}
}
}
if (arrMap.length > 0)
{ for (var i=0;i<arrMap[0].children.length;i++)
{ if (arrMap[0].children[i].nodeType == "ELEMENT")
{ var obj = new NavObjectiveMap(); obj.loadFromXMLNode(arrMap[0].children[i]); this.objectiveMaps[this.objectiveMaps.length] = obj;}
}
}
if (arrNavStateRules.length > 0)
{ for (var i=0;i<arrNavStateRules[0].children.length;i++)
{ if (arrNavStateRules[0].children[i].nodeType == "ELEMENT")
{ var navStateRule = new NavStateRule(); navStateRule.loadFromXMLNode(arrNavStateRules[0].children[i]); this.navStateRules[this.navStateRules.length] = navStateRule;}
}
}
if (arrPostStateRules.length > 0)
{ for (var i=0;i<arrPostStateRules[0].children.length;i++)
{ if (arrPostStateRules[0].children[i].nodeType == "ELEMENT")
{ var postStateRule = new NavPostRule(); postStateRule.loadFromXMLNode(arrPostStateRules[0].children[i]); this.postConditionRules[this.postConditionRules.length] = postStateRule;}
}
}
if (arrSelectionControls.length > 0)
{ for (var i=0;i<arrSelectionControls[0].children.length;i++)
{ if (arrSelectionControls[0].children[i].nodeType == "ELEMENT")
{ if (arrSelectionControls[0].children[i].tagName.toLowerCase() == "select")
{ var num = parseInt(arrSelectionControls[0].children[i].getAttribute("num")); var evt = arrSelectionControls[0].children[i].getAttribute("event"); switch (evt.toLowerCase())
{ case "init":evt=NAV_EVENT_INIT;break; case "reset":evt=NAV_EVENT_RESET;break;}
this.sSelect = num; this.sSelectEvent = evt;}
else if (arrSelectionControls[0].children[i].tagName.toLowerCase() == "randomizeonreset")
{ this.sRandomize = true;}
}
}
}
if (arrChildren.length > 0)
{ for (var i=0;i<arrChildren[0].children.length;i++)
{ if (arrChildren[0].children[i].nodeType == "ELEMENT")
{ var navNode = new NavNode(); navNode.loadFromXMLNode(arrChildren[0].children[i], this.navEngineRef); navNode.parentStack[0] = this; navNode.registerEvent("score","calculateScore",this,null,true); this.children[this.children.length] = navNode;}
}
}
}
function NavNodeEventMonitor(strEvent, value1, value2)
{ if (this.navEngineRef)
{ switch (strEvent.toLowerCase())
{ case "reorder":if (!this.registeredReorder) {this.registeredReorder = true;this.events.registerEvent("reorder","callbackReorder",this.navEngineRef,null,true);};break; case "attempted":if (!this.registeredAttempted) {this.registeredAttempted = true;this.events.registerEvent("attempted","callbackNodeAttempted",this.navEngineRef,null,true);};break; case "completed":if (!this.registeredCompleted) {this.registeredCompleted = true;this.events.registerEvent("completed","callbackNodeCompleted",this.navEngineRef,null,true);};break; case "satisfied":if (!this.registeredSatisfied) {this.registeredSatisfied = true;this.events.registerEvent("satisfied","callbackNodeSatisfied",this.navEngineRef,null,true);};break; case "score":if (!this.registeredCallbackNodeScore) {this.registeredCallbackNodeScore = true;this.events.registerEvent("score","callbackNodeScore",this.navEngineRef,null,true);};break; case "block":if (!this.registeredBlock) {this.registeredBlock = true;this.events.registerEvent("block","callbackNodeBlock",this.navEngineRef,null,true);};break; case "skip":if (!this.registeredSkip) {this.registeredSkip = true;this.events.registerEvent("skip","callbackNodeSkip",this.navEngineRef,null,true);};break; case "enabled":if (!this.registeredEnabled) {this.registeredEnabled = true;this.events.registerEvent("enabled","callbackNodeEnabled",this.navEngineRef,null,true);};break; case "visible":if (!this.registeredVisible) {this.registeredVisible = true;this.events.registerEvent("visible","callbackNodeVisible",this.navEngineRef,null,true);};break; case "choice":if (!this.registeredChoice) {this.registeredChoice = true;this.events.registerEvent("choice","callbackNodeChoice",this.navEngineRef,null,true);};break; case "flow":if (!this.registeredFlow) {this.registeredFlow = true;this.events.registerEvent("flow","callbackNodeFlow",this.navEngineRef,null,true);};break; case "forwardOnly":if (!this.registeredForwardOnly) {this.registeredForwardOnly = true;this.events.registerEvent("forwardOnly","callbackNodeForwardOnly",this.navEngineRef,null,true);};break;}
}
return true;}
/////////////////
// END NavNode //
/////////////////

////////////////////////
// BEGIN NavObjective //
////////////////////////
function NavObjective()
{ this.title = null; this.description = null; this.id = null; this.satisfied = null; this.score = null; this.events = null; this.setDefaultValues();}
NavObjective.prototype.loadFromXMLNode = NavObjectiveLoadFromXMLNode; NavObjective.prototype.setDefaultValues = NavObjectiveSetDefaultValues; NavObjective.prototype.toString = NavObjectiveToString; NavObjective.prototype.setSatisfied = NavObjectiveSetSatisfied; NavObjective.prototype.getSatisfied = NavObjectiveGetSatisfied; NavObjective.prototype.setScore = NavObjectiveSetScore; NavObjective.prototype.getScore = NavObjectiveGetScore; NavObjective.prototype.registerEvent = RegisterEvent; function NavObjectiveSetScore(score)
{ if (score > 100) score = 100; else if (score < -100) score = -100; if (this.score != score)
{ this.score = score; this.events.raiseEvent("score", this);}
}
function NavObjectiveGetScore(score)
{ return this.score;}
function NavObjectiveSetSatisfied(flag)
{ if (this.satisfied != flag)
{ this.satisfied = flag; this.events.raiseEvent("satisfied", this);}
}
function NavObjectiveGetSatisfied()
{ return this.satisfied;}
function NavObjectiveToString()
{ return "[Objective: id=\"" + this.id + "\" satisfied=\"" + this.satisfied + "\" score=\"" + this.score +"\"]";}
function NavObjectiveSetDefaultValues()
{ this.id = ""; this.title = ""; this.description = ""; this.satisfied = false; this.score = 0; this.events = new EventsObject(DEFAULT_OBJECTIVE_EVENTS);}
function NavObjectiveLoadFromXMLNode(xmlNode)
{ this.setDefaultValues(); this.id = xmlNode.getAttribute("id").toLowerCase(); this.title = xmlNode.getAttribute("title"); var descriptionNode = (xmlNode.getElements("description"))[0]; if (descriptionNode != null)
{ this.description = descriptionNode.getText();}
}
//////////////////////
// END NavObjective //
//////////////////////

////////////////////////
// BEGIN NavStateRule //
////////////////////////
function NavStateRule()
{ this.target = null; this.actions = null; this.combine = null; this.operator = null; this.conditions = null; this.events = null; this.setDefaultValues();}
NavStateRule.prototype.loadFromXMLNode = NavStateRuleLoadFromXMLNode; NavStateRule.prototype.setDefaultValues = NavStateRuleSetDefaultValues; NavStateRule.prototype.toString = NavStateRuleToString; NavStateRule.prototype.resolveReferences = NavStateRuleResolveReferences; NavStateRule.prototype.registerEvent = RegisterEvent; NavStateRule.prototype.evaluate = NavStateRuleEvaluate; NavStateRule.prototype.clone = NavStateRuleClone; function NavStateRuleClone()
{ var retVal = new NavStateRule(); retVal.target = this.target.id; retVal.actions = new Array(); for (var i=0;i<this.actions.length;i++)
{ retVal.actions[i] = this.actions[i];}
retVal.combine = this.combine; retVal.operator = this.operator; retVal.conditions = new Array(); for (var i=0;i<this.conditions.length;i++)
{ retVal.conditions[i] = this.conditions[i].clone();}
retVal.events = new EventsObject(DEFAULT_RULE_EVENTS); return retVal;}
function NavStateRuleEvaluate(ref)
{ var str = ""; var strOp = ((this.combine==NAV_COMBINE_AND)?("&&"):("||")); str = ((this.operator==NAV_OPERATOR_NOT)?("(!"):("")); for (var i=0;i<this.conditions.length;i++)
{ str += this.conditions[i].evaluate() + ((i<this.conditions.length-1)?(" " + strOp + " "):(""));}
str += ((this.operator==NAV_OPERATOR_NOT)?(")"):("")); if (eval(str) == true)
{ for (var i=0;i<this.actions.length;i++)
{ switch (this.actions[i])
{ case NAV_STATE_ACTION_MARK_COMPLETED:this.target.setCompleted(true);break; case NAV_STATE_ACTION_MARK_NOT_COMPLETED:this.target.setCompleted(false);break; case NAV_STATE_ACTION_MARK_SATISFIED:this.target.setSatisfied(true);break; case NAV_STATE_ACTION_MARK_NOT_SATISFIED:this.target.setSatisfied(false);break; case NAV_STATE_ACTION_ENABLE:this.target.setEnabled(true);break; case NAV_STATE_ACTION_DISABLE:this.target.setEnabled(false);break; case NAV_STATE_ACTION_HIDE:this.target.setVisible(false);break; case NAV_STATE_ACTION_SHOW:this.target.setVisible(true);break; case NAV_STATE_ACTION_SKIP:this.target.setSkip(true);break; case NAV_STATE_ACTION_DONT_SKIP:this.target.setSkip(false);break; case NAV_STATE_ACTION_BLOCK_FORWARD_PROGRESS:this.target.setBlock(true);break; case NAV_STATE_ACTION_ALLOW_FORWARD_PROGRESS:this.target.setBlock(false);break; case NAV_STATE_ACTION_ALLOW_CHOICE:this.target.setChoice(true);break; case NAV_STATE_ACTION_DONT_ALLOW_CHOICE:this.target.setChoice(false);break; case NAV_STATE_ACTION_ALLOW_FLOW:this.target.setFlow(true);break; case NAV_STATE_ACTION_DONT_ALLOW_FLOW:this.target.setFlow(false);break; case NAV_STATE_ACTION_ENFORCE_FORWARD_ONLY:this.target.setForwardOnly(true);break; case NAV_STATE_ACTION_DONT_ENFORCE_FORWARD_ONLY:this.target.setForwardOnly(false);break;}
}
}
}
function NavStateRuleResolveReferences(navRef)
{ for (var i=0;i<this.conditions.length;i++)
{ this.conditions[i].resolveReferences(navRef); this.conditions[i].registerEvent("changed","evaluate",this,null,true);}
}
function NavStateRuleToString()
{ var str = ""; var strOp = ((this.combine==NAV_COMBINE_AND)?("and"):("or")); var strAction = ""; for (var i=0;i<this.actions.length;i++)
{ switch (this.actions[i])
{ case NAV_STATE_ACTION_MARK_COMPLETED:strAction+="mark completed and ";break; case NAV_STATE_ACTION_MARK_NOT_COMPLETED:strAction+="mark not completed and ";break; case NAV_STATE_ACTION_MARK_SATISFIED:strAction+="mark satisfied and ";break; case NAV_STATE_ACTION_MARK_NOT_SATISFIED:strAction+="mark not satisfied and ";break; case NAV_STATE_ACTION_ENABLE:strAction+="enable and ";break; case NAV_STATE_ACTION_DISABLE:strAction+="disable and ";break; case NAV_STATE_ACTION_HIDE:strAction+="hide and ";break; case NAV_STATE_ACTION_SHOW:strAction+="show and ";break; case NAV_STATE_ACTION_SKIP:strAction+="skip and ";break; case NAV_STATE_ACTION_DONT_SKIP:strAction+="don't skip and ";break; case NAV_STATE_ACTION_BLOCK_FORWARD_PROGRESS:strAction+="block forward progress and ";break; case NAV_STATE_ACTION_ALLOW_FORWARD_PROGRESS:strAction+="allow forward progress and ";break; case NAV_STATE_ACTION_ALLOW_CHOICE:strAction+="allow choice navigation and ";break; case NAV_STATE_ACTION_DONT_ALLOW_CHOICE:strAction+="disable choice navigation and ";break; case NAV_STATE_ACTION_ALLOW_FLOW:strAction+="allow flow navigation and ";break; case NAV_STATE_ACTION_DONT_ALLOW_FLOW:strAction+="disable flow navigation and ";break; case NAV_STATE_ACTION_ENFORCE_FORWARD_ONLY:strAction+="enable forward only navigation and ";break; case NAV_STATE_ACTION_DONT_ENFORCE_FORWARD_ONLY:strAction+="disable forward only navigation and ";break;}
}
if (strAction.length > 0) strAction = strAction.slice(0,strAction.length-5); str = strAction + " if " + ((this.operator==NAV_OPERATOR_NOT)?("(not "):("")); for (var i=0;i<this.conditions.length;i++)
{ str += this.conditions[i].toString() + ((i<this.conditions.length-1)?(" " + strOp + " "):(""));}
str += ((this.operator==NAV_OPERATOR_NOT)?(")"):("")); return str;}
function NavStateRuleSetDefaultValues()
{ this.actions = new Array(); this.combine = NAV_COMBINE_AND; this.operator = NAV_OPERATOR_NO_OP; this.conditions = new Array(); this.events = new EventsObject(DEFAULT_RULE_EVENTS); this.target = null;}
function NavStateRuleLoadFromXMLNode(xmlNode)
{ this.setDefaultValues(); var action = xmlNode.getAttribute("actions"); if (action != null)
{ var actions = action.split(","); for (var i=0;i<actions.length;i++)
{ switch (actions[i].toLowerCase())
{ case "markcompleted":this.actions[this.actions.length] = NAV_STATE_ACTION_MARK_COMPLETED;break; case "marknotcompleted":this.actions[this.actions.length] = NAV_STATE_ACTION_MARK_NOT_COMPLETED;break; case "marksatisfied":this.actions[this.actions.length] = NAV_STATE_ACTION_MARK_SATISFIED;break; case "marknotsatisfied":this.actions[this.actions.length] = NAV_STATE_ACTION_MARK_NOT_SATISFIED;break; case "enable":this.actions[this.actions.length] = NAV_STATE_ACTION_ENABLE;break; case "disable":this.actions[this.actions.length] = NAV_STATE_ACTION_DISABLE;break; case "hide":this.actions[this.actions.length] = NAV_STATE_ACTION_HIDE;break; case "show":this.actions[this.actions.length] = NAV_STATE_ACTION_SHOW;break; case "skip":this.actions[this.actions.length] = NAV_STATE_ACTION_SKIP;break; case "donotskip":this.actions[this.actions.length] = NAV_STATE_ACTION_DONT_SKIP;break; case "blockforwardprogress":this.actions[this.actions.length] = NAV_STATE_ACTION_BLOCK_FORWARD_PROGRESS;break; case "allowforwardprogress":this.actions[this.actions.length] = NAV_STATE_ACTION_ALLOW_FORWARD_PROGRESS;break; case "enablechoice":this.actions[this.actions.length] = NAV_STATE_ACTION_ALLOW_CHOICE;break; case "disablechoice":this.actions[this.actions.length] = NAV_STATE_ACTION_DONT_ALLOW_CHOICE;break; case "enableflow":this.actions[this.actions.length] = NAV_STATE_ACTION_ALLOW_FLOW;break; case "disableflow":this.actions[this.actions.length] = NAV_STATE_ACTION_DONT_ALLOW_FLOW;break; case "enableforwardonly":this.actions[this.actions.length] = NAV_STATE_ACTION_ENFORCE_FORWARD_ONLY;break; case "disableforwardonly":this.actions[this.actions.length] = NAV_STATE_ACTION_DONT_ENFORCE_FORWARD_ONLY;break;}
}
}
var operator = xmlNode.getAttribute("operator"); switch ((operator+"").toLowerCase())
{ case "not":this.operator = NAV_OPERATOR_NOT;break; case "noop":this.operator = NAV_OPERATOR_NO_OP;break; default:this.operator = NAV_OPERATOR_NO_OP;break;}
var combine = xmlNode.getAttribute("combine"); switch ((combine+"").toLowerCase())
{ case "and":this.combine = NAV_COMBINE_AND;break; case "or":this.combine = NAV_COMBINE_OR;break; default:this.combine = NAV_COMBINE_AND;break;}
for (var i=0;i<xmlNode.children.length;i++)
{ if (xmlNode.children[i].nodeType == "ELEMENT")
{ var isAggregator; var objTemp; var nodeName = xmlNode.children[i].tagName.toLowerCase(); if (nodeName == "condand" || nodeName == "condor")
{ objTemp = new NavRuleConditionAggregator();}
else
{ objTemp = new NavRuleCondition();}
objTemp.loadFromXMLNode(xmlNode.children[i]); this.conditions[this.conditions.length] = objTemp;}
}
}
//////////////////////
// END NavStateRule //
//////////////////////

///////////////////////
// BEGIN NavPostRule //
///////////////////////
function NavPostRule()
{ this.direction = null; this.action = null; this.combine = null; this.operator = null; this.conditions = null; this.params = null; this.setDefaultValues();}
NavPostRule.prototype.loadFromXMLNode = NavPostRuleLoadFromXMLNode; NavPostRule.prototype.setDefaultValues = NavPostRuleSetDefaultValues; NavPostRule.prototype.toString = NavPostRuleToString; NavPostRule.prototype.resolveReferences = NavPostRuleResolveReferences; NavPostRule.prototype.evaluate = NavPostRuleEvaluate; NavPostRule.prototype.clone = NavPostRuleClone; function NavPostRuleClone()
{ var retVal = new NavPostRule(); retVal.direction = this.direction; retVal.action = this.action; retVal.combine = this.combine; retVal.operator = this.operator; retVal.conditions = new Array(); for (var i=0;i<this.conditions.length;i++)
{ retVal.conditions[i] = this.conditions[i].clone();}
retVal.params = new Array(); for (var i=0;i<this.params.length;i++)
{ retVal.params[i] = this.params[i];}
return retVal;}
function NavPostRuleEvaluate()
{ var str = ""; var strOp = ((this.combine==NAV_COMBINE_AND)?("&&"):("||")); str = ((this.operator==NAV_OPERATOR_NOT)?("(!"):("")); for (var i=0;i<this.conditions.length;i++)
{ str += this.conditions[i].evaluate() + ((i<this.conditions.length-1)?(" " + strOp + " "):(""));}
str += ((this.operator==NAV_OPERATOR_NOT)?(")"):("")); return (eval(str) == true);}
function NavPostRuleResolveReferences(navRef)
{ for (var i=0;i<this.conditions.length;i++)
{ this.conditions[i].resolveReferences(navRef);}
}
function NavPostRuleToString()
{ var str = ""; var strOp = ((this.combine==NAV_COMBINE_AND)?("and"):("or")); var strAction; switch (this.action)
{ case NAV_POST_ACTION_RESET:strAction="reset";break; case NAV_POST_ACTION_RETRY:strAction="retry";break; case NAV_POST_ACTION_NEXT:strAction="continue";break; case NAV_POST_ACTION_PREVIOUS:strAction="previous";break; case NAV_POST_ACTION_GOTO:strAction="goto " + this.params[0];break; case NAV_POST_ACTION_GOSUB:strAction="gosub " + this.params[0];break; case NAV_POST_ACTION_GOSUB_RETURN:strAction="gosub " + this.params[0] + " and return to " + this.params[1];break; case NAV_POST_ACTION_RESET+NAV_POST_ACTION_RETRY:strAction="reset and retry";break; case NAV_POST_ACTION_RESET+NAV_POST_ACTION_NEXT:strAction="reset and continue";break; case NAV_POST_ACTION_RESET+NAV_POST_ACTION_PREVIOUS:strAction="reset and previous";break; case NAV_POST_ACTION_RESET+NAV_POST_ACTION_GOTO:strAction="reset and goto " + this.params[0];break; case NAV_POST_ACTION_RESET+NAV_POST_ACTION_GOSUB:strAction="reset and gosub " + this.params[0];break; case NAV_POST_ACTION_RESET+NAV_POST_ACTION_GOSUB_RETURN:strAction="reset and gosub " + this.params[0] + " and return to " + this.params[1];break;}
str = strAction + " if " + ((this.operator==NAV_OPERATOR_NOT)?("(not "):("")); for (var i=0;i<this.conditions.length;i++)
{ str += this.conditions[i].toString() + ((i<this.conditions.length-1)?(" " + strOp + " "):(""));}
str += ((this.operator==NAV_OPERATOR_NOT)?(")"):("")); str += ((this.direction & NAV_DIRECTION_REVERSE > 0)?("<-"):("")) + ((this.direction & NAV_DIRECTION_FORWARD > 0)?("->"):(""))
return str;}
function NavPostRuleSetDefaultValues()
{ this.direction = NAV_DIRECTION_FORWARD; this.action = NAV_POST_ACTION_NEXT; this.combine = NAV_COMBINE_AND; this.operator = NAV_OPERATOR_NO_OP; this.conditions = new Array(); this.params = new Array();}
function NavPostRuleLoadFromXMLNode(xmlNode)
{ var temp; this.setDefaultValues(); var action = xmlNode.getAttribute("action"); switch (action.toLowerCase())
{ case "reset":this.action = NAV_POST_ACTION_RESET;this.params = "";break; case "retry":this.action = NAV_POST_ACTION_RETRY;this.params = "";break; case "resetandretry":this.action = NAV_POST_ACTION_RESET + NAV_POST_ACTION_RETRY;this.params = "";break; case "next":this.action = NAV_POST_ACTION_NEXT;this.params = "";break; case "nextandreset":this.action = NAV_POST_ACTION_RESET + NAV_POST_ACTION_NEXT;this.params = "";break; case "previous":this.action = NAV_POST_ACTION_PREVIOUS;this.params = "";break; case "previousandreset":this.action = NAV_POST_ACTION_RESET + NAV_POST_ACTION_PREVIOUS;this.params = "";break; case "goto":
this.action = NAV_POST_ACTION_GOTO; this.params = trimWhitespace(xmlNode.getAttribute("params")).split(","); break; case "gotoandreset":
this.action = NAV_POST_ACTION_RESET + NAV_POST_ACTION_GOTO; this.params = trimWhitespace(xmlNode.getAttribute("params")).split(","); break; case "gosub":
this.action = NAV_POST_ACTION_GOSUB; this.params = trimWhitespace(xmlNode.getAttribute("params")).split(","); break; case "gosubandreset":
this.action = NAV_POST_ACTION_RESET + NAV_POST_ACTION_GOSUB; this.params = trimWhitespace(xmlNode.getAttribute("params")).split(","); break; case "gosubreturn":
this.action = NAV_POST_ACTION_GOSUB_RETURN; this.params = trimWhitespace(xmlNode.getAttribute("params")).split(","); break; case "gosubreturnandreset":
this.action = NAV_POST_ACTION_RESET + NAV_POST_ACTION_GOSUB_RETURN; this.params = trimWhitespace(xmlNode.getAttribute("params")).split(","); break;}
var operator = xmlNode.getAttribute("operator"); switch ((operator+"").toLowerCase())
{ case "not":this.operator = NAV_OPERATOR_NOT;break; case "noop":this.operator = NAV_OPERATOR_NO_OP;break; default:this.operator = NAV_OPERATOR_NO_OP;break;}
var combine = xmlNode.getAttribute("combine"); switch ((combine+"").toLowerCase())
{ case "and":this.combine = NAV_COMBINE_AND;break; case "or":this.combine = NAV_COMBINE_OR;break; default:this.combine = NAV_COMBINE_AND;break;}
for (var i=0;i<xmlNode.children.length;i++)
{ if (xmlNode.children[i].nodeType == "ELEMENT")
{ var isAggregator; var objTemp; var nodeName = xmlNode.children[i].tagName.toLowerCase(); if (nodeName == "condand" || nodeName == "condor")
{ objTemp = new NavRuleConditionAggregator();}
else
{ objTemp = new NavRuleCondition();}
objTemp.loadFromXMLNode(xmlNode.children[i]); this.conditions[this.conditions.length] = objTemp;}
}
temp = xmlNode.getAttribute("forward"); if (temp != null)
{ if ((temp+"").toLowerCase() == "false")
{ this.direction = NAV_DIRECTION_REVERSE;}
}
if (this.direction != NAV_DIRECTION_REVERSE)
{ temp = xmlNode.getAttribute("reverse"); if (temp != null)
{ if ((temp+"").toLowerCase() == "true")
{ this.direction = NAV_DIRECTION_REVERSE + NAV_DIRECTION_FORWARD;}
}
}
}
function trimWhitespace(strVal)
{ if (strVal == null) strVal = ""; var strTemp = ""; var charCode = 0; for (var i=0;i<strVal.length;i++)
{ charCode = strVal.charCodeAt(i); if (charCode > 32)
{ strTemp = strVal.slice(i,strVal.length); break;}
}
for (var i=strTemp.length-1;i>-1;i--)
{ charCode = strVal.charCodeAt(i); if (charCode > 32)
{ strTemp = strTemp.slice(0,i+1); break;}
}
return strTemp;}
/////////////////////
// END NavPostRule //
/////////////////////

//////////////////////////
// BEGIN NavRuleCondAgg //
//////////////////////////
function NavRuleConditionAggregator()
{ this.combine = null; this.conditions = null; this.operator = null; this.events = null; this.setDefaultValues();}
NavRuleConditionAggregator.prototype.loadFromXMLNode = NavRuleConditionAggregatorLoadFromXMLNode; NavRuleConditionAggregator.prototype.setDefaultValues = NavRuleConditionAggregatorSetDefaultValues; NavRuleConditionAggregator.prototype.toString = NavRuleConditionAggregatorToString; NavRuleConditionAggregator.prototype.resolveReferences = NavRuleConditionAggregatorResolveReferences; NavRuleConditionAggregator.prototype.registerEvent = RegisterEvent; NavRuleConditionAggregator.prototype.changed = NavRuleConditionAggregatorChanged; NavRuleConditionAggregator.prototype.evaluate = NavRuleConditionAggregatorEvaluate; NavRuleConditionAggregator.prototype.clone = NavRuleConditionAggregatorClone; function NavRuleConditionAggregatorClone()
{ var retVal = new NavRuleConditionAggregator(); retVal.combine = this.combine; retVal.conditions = new Array(); for (var i=0;i<this.conditions.length;i++)
{ retVal.conditions[i] = this.conditions[i].clone();}
retVal.operator = this.operator; retVal.events = new EventsObject(DEFAULT_RULE_EVENTS); return retVal;}
function NavRuleConditionAggregatorChanged(ref)
{ this.events.raiseEvent("changed",this);}
function NavRuleConditionAggregatorResolveReferences(navRef)
{ for (var i=0;i<this.conditions.length;i++)
{ this.conditions[i].resolveReferences(navRef); this.conditions[i].registerEvent("changed","changed",this,null,true);}
}
function NavRuleConditionAggregatorToString()
{ var str = "(" + ((this.operator==NAV_OPERATOR_NOT)?("not ("):("")); var strOp = ((this.combine==NAV_COMBINE_AND)?("and"):("or")); for (var i=0;i<this.conditions.length;i++)
{ str += this.conditions[i].toString() + ((i<this.conditions.length-1)?(" " + strOp + " "):(""));}
str += ((this.operator==NAV_OPERATOR_NOT)?(")"):("")) + ")"; return str;}
function NavRuleConditionAggregatorEvaluate()
{ var str = "(" + ((this.operator==NAV_OPERATOR_NOT)?("!("):("")); var strOp = ((this.combine==NAV_COMBINE_AND)?("&&"):("||")); for (var i=0;i<this.conditions.length;i++)
{ str += this.conditions[i].evaluate() + ((i<this.conditions.length-1)?(" " + strOp + " "):(""));}
str += ((this.operator==NAV_OPERATOR_NOT)?(")"):("")) + ")"; return eval(str);}
function NavRuleConditionAggregatorSetDefaultValues()
{ this.combine = NAV_COMBINE_AND; this.conditions = new Array(); this.operator = NAV_OPERATOR_NO_OP; this.events = new EventsObject(DEFAULT_RULE_EVENTS);}
function NavRuleConditionAggregatorLoadFromXMLNode(xmlNode)
{ this.setDefaultValues(); var combine = xmlNode.tagName; switch (combine.toLowerCase())
{ case "condand":this.combine = NAV_COMBINE_AND;break; case "condor":this.combine = NAV_COMBINE_OR;break;}
for (var i=0;i<xmlNode.children.length;i++)
{ if (xmlNode.children[i].nodeType == "ELEMENT")
{ var isAggregator; var objTemp; var nodeName = xmlNode.children[i].tagName.toLowerCase(); if (nodeName == "condand" || nodeName == "condor")
{ objTemp = new NavRuleConditionAggregator();}
else
{ objTemp = new NavRuleCondition();}
objTemp.loadFromXMLNode(xmlNode.children[i]); this.conditions[this.conditions.length] = objTemp;}
}
var operator = xmlNode.getAttribute("operator"); switch ((operator+"").toLowerCase())
{ case "not":this.operator = NAV_OPERATOR_NOT;break; case "noop":this.operator = NAV_OPERATOR_NO_OP;break; default:this.operator = NAV_OPERATOR_NO_OP;break;}
}
////////////////////////
// END NavRuleCondAgg //
////////////////////////

////////////////////////////
// BEGIN NavRuleCondition //
////////////////////////////
function NavRuleCondition()
{ this.criteria = null; this.target = null; this.threshold = null; this.thresholdType = null; this.operator = null; this.useChildren = null; this.events = null; this.setDefaultValues();}
NavRuleCondition.prototype.loadFromXMLNode = NavRuleConditionLoadFromXMLNode; NavRuleCondition.prototype.setDefaultValues = NavRuleConditionSetDefaultValues; NavRuleCondition.prototype.toString = NavRuleConditionToString; NavRuleCondition.prototype.resolveReferences = NavRuleConditionResolveReferences; NavRuleCondition.prototype.registerEvent = RegisterEvent; NavRuleCondition.prototype.changed = NavRuleConditionChanged; NavRuleCondition.prototype.evaluate = NavRuleConditionEvaluate; NavRuleCondition.prototype.clone = NavRuleConditionClone; function NavRuleConditionClone()
{ var retVal = new NavRuleCondition(); retVal.criteria = this.criteria; retVal.target = this.target.id; retVal.threshold = this.threshold; retVal.thresholdType = this.thresholdType; retVal.operator = this.operator; retVal.useChildren = this.useChildren; retVal.events = new EventsObject(DEFAULT_RULE_EVENTS); return retVal;}
function NavRuleConditionChanged(ref)
{ this.events.raiseEvent("changed", this);}
function NavRuleConditionResolveReferences(navRef)
{ this.target = navRef.getNodeById(this.target); if (this.useChildren)
{ for (var i=0;i<this.target.children.length;i++)
{ switch (this.criteria)
{ case NAV_CRITERIA_ATTEMPTED:this.target.children[i].registerEvent("attempted","changed",this,null,true);break; case NAV_CRITERIA_COMPLETED:this.target.children[i].registerEvent("completed","changed",this,null,true);break; case NAV_CRITERIA_SATISFIED:this.target.children[i].registerEvent("satisfied","changed",this,null,true);break;}
}
}
else
{ switch (this.criteria)
{ case NAV_CRITERIA_ATTEMPTED:this.target.registerEvent("attempted","changed",this,null,true);break; case NAV_CRITERIA_COMPLETED:this.target.registerEvent("completed","changed",this,null,true);break; case NAV_CRITERIA_SATISFIED:this.target.registerEvent("satisfied","changed",this,null,true);break; case NAV_CRITERIA_SCORE:this.target.registerEvent("score","changed",this,null,true);break;}
}
}
function NavRuleConditionToString()
{ var str = ""; var strCriteria = ""; switch (this.criteria)
{ case NAV_CRITERIA_ATTEMPTED:strCriteria="attempted";break; case NAV_CRITERIA_COMPLETED:strCriteria="completed";break; case NAV_CRITERIA_SATISFIED:strCriteria="satisfied";break;}
if (this.useChildren)
{ if (this.thresholdType == NAV_THRESHOLD_NUMBER)
{ str = "(" + ((this.operator==NAV_OPERATOR_NO_OP)?(""):("not ")) + "at least " + this.threshold + " children of " + this.target.id + " are " + strCriteria + ")";}
else
{ str = "(" + ((this.operator==NAV_OPERATOR_NO_OP)?(""):("not ")) + "at least " + this.threshold + "% of the children of " + this.target.id + " are " + strCriteria + ")";}
}
else
{ if (this.criteria == NAV_CRITERIA_SCORE)
{ str = "(" + this.target.id + " score is " + ((this.operator==NAV_OPERATOR_NO_OP)?(""):("not ")) + ">= " + this.threshold + ")";}
else
{ str = "(" + this.target.id + " is " + ((this.operator==NAV_OPERATOR_NO_OP)?(""):("not ")) + strCriteria + ")";}
}
return str;}
function NavRuleConditionEvaluate()
{ var accumulator = 0; var str = ""; if (this.useChildren)
{ var childArray = this.target.children; if (this.target.selectedChildren.length > 0)
{ childArray = this.target.selectedChildren;}
for (var i=0;i<childArray.length;i++)
{ switch (this.criteria)
{ case NAV_CRITERIA_ATTEMPTED:if (childArray[i].getAttempted()) accumulator++;break; case NAV_CRITERIA_COMPLETED:if (childArray[i].getCompleted()) accumulator++;break; case NAV_CRITERIA_SATISFIED:if (childArray[i].getSatisfied()) accumulator++;break;}
}
if (this.thresholdType == NAV_THRESHOLD_NUMBER)
{ str = "(" + ((this.operator==NAV_OPERATOR_NO_OP)?(""):("!")) + (accumulator >= this.threshold) + ")";}
else
{ str = "(" + ((this.operator==NAV_OPERATOR_NO_OP)?(""):("!")) + ((accumulator/childArray.length*100) >= this.threshold) + ")";}
}
else
{ if (this.criteria == NAV_CRITERIA_SCORE)
{ str = "(" + ((this.operator==NAV_OPERATOR_NO_OP)?(""):("!")) + (this.target.getScore() >= this.threshold) + ")";}
else
{ switch (this.criteria)
{ case NAV_CRITERIA_ATTEMPTED:str = "(" + ((this.operator==NAV_OPERATOR_NO_OP)?(""):("!")) + this.target.getAttempted() + ")";break; case NAV_CRITERIA_COMPLETED:str = "(" + ((this.operator==NAV_OPERATOR_NO_OP)?(""):("!")) + this.target.getCompleted() + ")";break; case NAV_CRITERIA_SATISFIED:str = "(" + ((this.operator==NAV_OPERATOR_NO_OP)?(""):("!")) + this.target.getSatisfied() + ")";break;}
}
}
return eval(str);}
function NavRuleConditionSetDefaultValues()
{ this.criteria = NAV_CRITERIA_COMPLETED; this.target = null; this.threshold = 0; this.thresholdType = NAV_THRESHOLD_NUMBER; this.operator = NAV_OPERATOR_NO_OP; this.useChildren = false; this.events = new EventsObject(DEFAULT_RULE_EVENTS);}
function NavRuleConditionLoadFromXMLNode(xmlNode)
{ this.setDefaultValues(); var criteria = xmlNode.tagName; switch (criteria.toLowerCase())
{ case "condattempted":this.criteria=NAV_CRITERIA_ATTEMPTED;this.threshold=0;break; case "condcompleted":this.criteria=NAV_CRITERIA_COMPLETED;this.threshold=0;break; case "condsatisfied":this.criteria=NAV_CRITERIA_SATISFIED;this.threshold=0;break; case "condminscore":
this.criteria=NAV_CRITERIA_SCORE; this.threshold = floatParse(xmlNode.getAttribute("threshold"),SCORE_PRECISION); break; case "condpercentchildren":
var criteria = xmlNode.getAttribute("criteria"); switch (criteria.toLowerCase())
{ case "attempted":this.criteria=NAV_CRITERIA_ATTEMPTED;break; case "completed":this.criteria=NAV_CRITERIA_COMPLETED;break; case "satisfied":this.criteria=NAV_CRITERIA_SATISFIED;break; default:this.criteria=NAV_CRITERIA_COMPLETED;break;}
this.thresholdType=NAV_THRESHOLD_PERCENT; this.threshold = floatParse(xmlNode.getAttribute("threshold"),SCORE_PRECISION); this.useChildren = true; break; case "condnumberchildren":
var criteria = xmlNode.getAttribute("criteria"); switch (criteria.toLowerCase())
{ case "attempted":this.criteria=NAV_CRITERIA_ATTEMPTED;break; case "completed":this.criteria=NAV_CRITERIA_COMPLETED;break; case "satisfied":this.criteria=NAV_CRITERIA_SATISFIED;break; default:this.criteria=NAV_CRITERIA_COMPLETED;break;}
this.thresholdType=NAV_THRESHOLD_NUMBER; this.threshold = parseInt(xmlNode.getAttribute("threshold")); this.useChildren = true; break;}
var operator = xmlNode.getAttribute("operator"); switch ((operator+"").toLowerCase())
{ case "not":this.operator = NAV_OPERATOR_NOT;break; case "noop":this.operator = NAV_OPERATOR_NO_OP;break; default:this.operator = NAV_OPERATOR_NO_OP;break;}
this.target = xmlNode.getAttribute("targetId");}
//////////////////////////
// END NavRuleCondition //
//////////////////////////

/////////////////////////////
// BEGIN NavSequenceEngine //
/////////////////////////////
function NavSeqEngine(navEngine)
{ this.navEngine = navEngine; this.firstNodeInSequence = SequenceEngineFirstNodeInSequence; this.nextInSequence = SequenceEngineNextInSequence; this.previousInSequence = SequenceEnginePreviousInSequence; this.next = Parent_Sibling_Next; this.previous = Parent_Sibling_Previous; this.nextDown = First_Left_Down; this.previousDown = First_Right_Down;}
function SequenceEngineFirstNodeInSequence(nodeRef)
{ if (nodeRef == null) return null; this.navEngine.blockedNode = null; var retVal = this.nextDown(nodeRef); if (retVal == null)
{ retVal = this.next(nodeRef,false);}
return retVal;}
function SequenceEngineNextInSequence(nodeRef, bolAdjust)
{ if (nodeRef == null) return null; if (bolAdjust == null) bolAdjust = false; this.navEngine.blockedNode = null; return this.next(nodeRef, bolAdjust);}
function SequenceEnginePreviousInSequence(nodeRef, bolAdjust)
{ if (nodeRef == null) return null; if (bolAdjust == null) bolAdjust = false; this.navEngine.blockedNode = null; return this.previous(nodeRef, bolAdjust);}
function Parent_Sibling_Next(ptrCurrent, bolAdjust)
{ var retVal = new Object(); retVal.destination = null; retVal.returnLocation = null; var postAction = ptrCurrent.getPostAction(NAV_DIRECTION_FORWARD); if ((postAction.value & NAV_POST_ACTION_RESET) == NAV_POST_ACTION_RESET)
{ if (bolAdjust)
{ ptrCurrent.reset();}
postAction.value -= NAV_POST_ACTION_RESET;}
switch (postAction.value)
{ case NAV_POST_ACTION_RETRY:retVal.destination=ptrCurrent;return retVal;break; case NAV_POST_ACTION_NEXT:break; case NAV_POST_ACTION_PREVIOUS:return this.previous(ptrCurrent,bolAdjust);break; case NAV_POST_ACTION_GOTO:
if (this.navEngine.evalGotoNode(postAction.parameters[0])==NAV_DENY_NONE)
{ retVal.destination = this.firstNodeInSequence(this.navEngine.getNodeById(postAction.parameters[0])); if (retVal.destination == null)
{ return null;}
else
{ return retVal;}
}
else
{ return null;}
break; case NAV_POST_ACTION_GOSUB:retVal.destination=this.navEngine.getNodeById(postAction.parameters[0]);retVal.returnLocation=ptrCurrent;return retVal;break; case NAV_POST_ACTION_GOSUB_RETURN:retVal.destination=this.navEngine.getNodeById(postAction.parameters[0]);retVal.returnLocation=this.navEngine.getNodeById(postAction.parameters[1]);return retVal;break;}
if (ptrCurrent.parentStack.length == 0)
{ return null;}
if (ptrCurrent.getBlock())
{ this.navEngine.blockedNode = ptrCurrent; return null;}
var ptrParent = ptrCurrent.parentStack[ptrCurrent.parentStack.length-1]; if (bolAdjust && ((this.navEngine.isRootNode(ptrCurrent) && ptrCurrent.parentStack.length > 0) || (!this.navEngine.isRootNode(ptrCurrent) && ptrCurrent.parentStack.length > 1)))
{ ptrCurrent.parentStack.length--;}
if (ptrParent.url != "")
{ retVal.destination = ptrParent; return retVal;}
var intStartIndex = null; var parentChildArray; if (ptrParent.selectedChildren.length > 0)
{ parentChildArray = ptrParent.selectedChildren;}
else
{ parentChildArray = ptrParent.children;}
for (var i=0;i<parentChildArray.length-1;i++)
{ if (parentChildArray[i] == ptrCurrent)
{ intStartIndex = i+1; break;}
}
var ptrNextNode = null; if (intStartIndex != null)
{ for (var i=intStartIndex;i<parentChildArray.length;i++)
{ if ( parentChildArray[i].getEnabled() && !parentChildArray[i].getSkip() )
{ ptrNextNode = this.nextDown(parentChildArray[i])
if (this.navEngine.blockedNode != null)
{ return null;}
if (ptrNextNode != null)
{ break;}
}
if (parentChildArray[i].getBlock())
{ this.navEngine.blockedNode = parentChildArray[i]; return null;}
}
}
if (ptrNextNode == null)
{ return this.next(ptrParent,bolAdjust);}
retVal.destination = ptrNextNode; return retVal;}
function First_Left_Down(ptrNode)
{ if (ptrNode.url != "")
{ return ptrNode;}
var ptrNextNode = null; var childArray; if (ptrNode.selectedChildren.length > 0)
{ childArray = ptrNode.selectedChildren;}
else
{ childArray = ptrNode.children;}
for (var i=0;i<childArray.length;i++)
{ if (childArray[i].getEnabled() && !childArray[i].getSkip())
{ ptrNextNode = this.nextDown(childArray[i]); if (this.navEngine.blockedNode != null)
{ return null;}
if (ptrNextNode != null)
{ break;}
}
if (childArray[i].getBlock())
{ this.navEngine.blockedNode = childArray[i]; return null;}
}
return ptrNextNode;}
function Parent_Sibling_Previous(ptrCurrent, bolAdjust)
{ var retVal = new Object(); retVal.destination = null; retVal.returnLocation = null; var postAction = ptrCurrent.getPostAction(NAV_DIRECTION_REVERSE); if ((postAction.value & NAV_POST_ACTION_RESET) == NAV_POST_ACTION_RESET)
{ if (bolAdjust)
{ ptrCurrent.reset();}
postAction.value -= NAV_POST_ACTION_RESET;}
switch (postAction.value)
{ case NAV_POST_ACTION_RETRY:retVal.destination=ptrCurrent;return retVal;break; case NAV_POST_ACTION_NEXT:return this.next(ptrCurrent,bolAdjust);break; case NAV_POST_ACTION_PREVIOUS:break; case NAV_POST_ACTION_GOTO:
if (this.navEngine.evalGotoNode(postAction.parameters[0])==NAV_DENY_NONE)
{ retVal.destination = this.firstNodeInSequence(this.navEngine.getNodeById(postAction.parameters[0])); if (retVal.destination == null)
{ return null;}
else
{ return retVal;}
}
else
{ return null;}
break; case NAV_POST_ACTION_GOSUB:retVal.destination=this.navEngine.getNodeById(postAction.parameters[0]);retVal.returnLocation=ptrCurrent;return retVal;break; case NAV_POST_ACTION_GOSUB_RETURN:retVal.destination=this.navEngine.getNodeById(postAction.parameters[0]);retVal.returnLocation=this.navEngine.getNodeById(postAction.parameters[1]);return retVal;break;}
if (ptrCurrent.parentStack.length == 0)
{ return null;}
if (ptrCurrent.parentStack[0].cForwardOnly)
{ this.navEngine.blockedNode = ptrCurrent; return null;}
var ptrParent = ptrCurrent.parentStack[ptrCurrent.parentStack.length-1]; if (bolAdjust && ((this.navEngine.isRootNode(ptrCurrent) && ptrCurrent.parentStack.length > 0) || (!this.navEngine.isRootNode(ptrCurrent) && ptrCurrent.parentStack.length > 1)))
{ ptrCurrent.parentStack.length--;}
if (ptrParent.url != "")
{ retVal.destination = ptrParent; return retVal;}
var intStartIndex = null; var parentChildArray; if (ptrParent.selectedChildren.length > 0)
{ parentChildArray = ptrParent.selectedChildren;}
else
{ parentChildArray = ptrParent.children;}
for (var i=1;i<parentChildArray.length;i++)
{ if (parentChildArray[i] == ptrCurrent)
{ intStartIndex = i-1; break;}
}
var ptrPreviousNode = null; if (intStartIndex != null)
{ for (var i=intStartIndex;i>-1;i--)
{ if (parentChildArray[i].getEnabled() && !parentChildArray[i].getSkip())
{ ptrPreviousNode = this.previousDown(parentChildArray[i])
if (ptrPreviousNode != null)
{ break;}
}
}
}
if (ptrPreviousNode == null)
{ return this.previous(ptrParent,bolAdjust);}
retVal.destination = ptrPreviousNode; return retVal;}
function First_Right_Down(ptrNode)
{ if (ptrNode.url != "")
{ return ptrNode;}
var ptrPreviousNode = null; var childArray; if (ptrNode.selectedChildren.length > 0)
{ childArray = ptrNode.selectedChildren;}
else
{ childArray = ptrNode.children;}
for (var i=childArray.length-1;i>-1;i--)
{ if (childArray[i].getEnabled() && !childArray[i].getSkip())
{ ptrPreviousNode = this.previousDown(childArray[i]); if (ptrPreviousNode != null)
{ break;}
}
}
return ptrPreviousNode;}
///////////////////////////
// END NavSequenceEngine //
///////////////////////////
